/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RouterBlock
extends DeviceBlock.Colored {
    public static final MapCodec<RouterBlock> CODEC = RouterBlock.simpleCodec(RouterBlock::new);
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    private static final VoxelShape[] BODY_BOUNDING_BOX = new VoxelShape[]{RouterBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)14.0), RouterBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)14.0), RouterBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)14.0), RouterBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)14.0)};
    private static final VoxelShape[] BODY_VERTICAL_BOUNDING_BOX = new VoxelShape[]{RouterBlock.box((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0), RouterBlock.box((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0), RouterBlock.box((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0), RouterBlock.box((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0)};
    private static final VoxelShape[] SELECTION_BOUNDING_BOX = new VoxelShape[]{RouterBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), RouterBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), RouterBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0), RouterBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0)};
    private static final VoxelShape[] SELECTION_VERTICAL_BOUNDING_BOX = new VoxelShape[]{RouterBlock.box((double)13.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0), RouterBlock.box((double)13.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0), RouterBlock.box((double)13.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0), RouterBlock.box((double)13.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0)};

    public RouterBlock(DyeColor color) {
        this(color, BlockBehaviour.Properties.of().mapColor(color).strength(6.0f).sound(SoundType.METAL));
    }

    public RouterBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties, color, DeviceType.ROUTER);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false)));
    }

    public RouterBlock(BlockBehaviour.Properties properties) {
        this(DyeColor.WHITE, properties);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)pState.getValue((Property)VERTICAL)).booleanValue()) {
                    yield BODY_VERTICAL_BOUNDING_BOX[0];
                }
                yield BODY_BOUNDING_BOX[0];
            }
            case Direction.EAST -> {
                if (((Boolean)pState.getValue((Property)VERTICAL)).booleanValue()) {
                    yield BODY_VERTICAL_BOUNDING_BOX[1];
                }
                yield BODY_BOUNDING_BOX[1];
            }
            case Direction.SOUTH -> {
                if (((Boolean)pState.getValue((Property)VERTICAL)).booleanValue()) {
                    yield BODY_VERTICAL_BOUNDING_BOX[2];
                }
                yield BODY_BOUNDING_BOX[2];
            }
            case Direction.WEST -> {
                if (((Boolean)pState.getValue((Property)VERTICAL)).booleanValue()) {
                    yield BODY_VERTICAL_BOUNDING_BOX[3];
                }
                yield BODY_BOUNDING_BOX[3];
            }
            default -> BODY_BOUNDING_BOX[0];
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return state != null ? (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(pContext.getClickLocation().y - pContext.getClickLocation().y > 0.5)) : null;
    }

    @Override
    @NotNull
    @Contract(value="_, _ -> new")
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RouterBlockEntity(pos, state);
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{VERTICAL});
    }
}

