/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.computer;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.block.ComputerBlock;
import dev.ultreon.devices.block.entity.computer.LaptopBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaptopBlock
extends ComputerBlock.Colored {
    public static final MapCodec<LaptopBlock> CODEC = LaptopBlock.simpleCodec(LaptopBlock::new);
    public static final EnumProperty<ComputerBlock.Type> TYPE = EnumProperty.create((String)"type", ComputerBlock.Type.class);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    private static final VoxelShape SHAPE_OPEN_NORTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)12.5, (double)15.0, (double)11.4, (double)17.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.3, (double)12.5));
    private static final VoxelShape SHAPE_OPEN_EAST = Shapes.or((VoxelShape)Block.box((double)-1.0, (double)0.0, (double)1.0, (double)3.5, (double)11.4, (double)15.0), (VoxelShape)Block.box((double)3.5, (double)0.0, (double)1.0, (double)15.0, (double)1.3, (double)15.0));
    private static final VoxelShape SHAPE_OPEN_SOUTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)-1.0, (double)15.0, (double)11.4, (double)3.5), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)3.5, (double)15.0, (double)1.3, (double)15.0));
    private static final VoxelShape SHAPE_OPEN_WEST = Shapes.or((VoxelShape)Block.box((double)12.5, (double)0.0, (double)1.0, (double)17.0, (double)11.4, (double)15.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)12.5, (double)1.3, (double)15.0));
    private static final VoxelShape SHAPE_CLOSED_NORTH = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)13.0);
    private static final VoxelShape SHAPE_CLOSED_EAST = Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape SHAPE_CLOSED_SOUTH = Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape SHAPE_CLOSED_WEST = Block.box((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)2.0, (double)15.0);

    public LaptopBlock(DyeColor color) {
        this(BlockBehaviour.Properties.of().mapColor(color).strength(6.0f).sound(SoundType.METAL), color);
    }

    private LaptopBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color, DeviceType.COMPUTER);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)ComputerBlock.Type.BASE))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    private LaptopBlock(BlockBehaviour.Properties properties) {
        super(properties, DyeColor.WHITE, DeviceType.COMPUTER);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)ComputerBlock.Type.BASE))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        VoxelShape voxelShape;
        block13: {
            block12: {
                if (!((Boolean)pState.getValue((Property)OPEN)).booleanValue()) break block12;
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        voxelShape = SHAPE_OPEN_NORTH;
                        break block13;
                    }
                    case EAST: {
                        voxelShape = SHAPE_OPEN_EAST;
                        break block13;
                    }
                    case SOUTH: {
                        voxelShape = SHAPE_OPEN_SOUTH;
                        break block13;
                    }
                    case WEST: {
                        voxelShape = SHAPE_OPEN_WEST;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                    }
                }
            }
            switch ((Direction)pState.getValue((Property)FACING)) {
                case NORTH: {
                    voxelShape = SHAPE_CLOSED_NORTH;
                    break;
                }
                case EAST: {
                    voxelShape = SHAPE_CLOSED_EAST;
                    break;
                }
                case SOUTH: {
                    voxelShape = SHAPE_CLOSED_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = SHAPE_CLOSED_WEST;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                }
            }
        }
        return voxelShape;
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{TYPE, OPEN});
    }

    @Override
    public boolean isDesktopPC() {
        return false;
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity parameter = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter == null) {
            return drops;
        }
        for (ItemStack drop : drops) {
            BlockItem blockItem;
            Item item = drop.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof LaptopBlock)) continue;
            Level level = parameter.getLevel();
            if (level == null) {
                level = builder.getLevel();
            }
            parameter.saveToItem(drop, (HolderLookup.Provider)level.registryAccess());
        }
        return drops;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LaptopBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

