/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.computer;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.block.ComputerBlock;
import dev.ultreon.devices.block.computer.FakeBlockPlaceContext;
import dev.ultreon.devices.block.computer.MacMaxXBlockPart;
import dev.ultreon.devices.block.entity.computer.MacMaxXBlockEntity;
import dev.ultreon.devices.init.DeviceBlocks;
import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacMaxXBlock
extends ComputerBlock {
    private static final MapCodec<MacMaxXBlock> CODEC = MacMaxXBlock.simpleCodec(MacMaxXBlock::new);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)-16.0, (double)31.0, (double)5.0, (double)32.0, (double)32.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-15.0, (double)4.0, (double)5.5, (double)31.0, (double)32.0, (double)7.0), Block.box((double)-16.0, (double)5.0, (double)5.0, (double)-15.0, (double)32.0, (double)7.0), Block.box((double)-16.0, (double)3.0, (double)5.0, (double)32.0, (double)7.0, (double)7.0), Block.box((double)31.0, (double)5.0, (double)5.0, (double)32.0, (double)32.0, (double)7.0), Block.box((double)-6.0, (double)0.5, (double)6.5, (double)-2.0, (double)19.0, (double)9.0), Block.box((double)20.0, (double)0.5, (double)6.5, (double)24.0, (double)19.0, (double)9.0), Block.box((double)0.0, (double)13.0, (double)6.5, (double)18.0, (double)27.0, (double)8.0), Block.box((double)19.0, (double)0.0, (double)6.5, (double)25.0, (double)0.5, (double)9.0), Block.box((double)-7.0, (double)0.0, (double)6.5, (double)-1.0, (double)0.5, (double)9.0)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)31.0, (double)-16.0, (double)11.0, (double)32.0, (double)32.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)4.0, (double)-15.0, (double)10.5, (double)32.0, (double)31.0), Block.box((double)9.0, (double)5.0, (double)-16.0, (double)11.0, (double)32.0, (double)-15.0), Block.box((double)9.0, (double)3.0, (double)-16.0, (double)11.0, (double)7.0, (double)32.0), Block.box((double)9.0, (double)5.0, (double)31.0, (double)11.0, (double)32.0, (double)32.0), Block.box((double)7.0, (double)0.5, (double)-6.0, (double)9.5, (double)19.0, (double)-2.0), Block.box((double)7.0, (double)0.5, (double)20.0, (double)9.5, (double)19.0, (double)24.0), Block.box((double)8.0, (double)13.0, (double)0.0, (double)9.5, (double)27.0, (double)18.0), Block.box((double)7.0, (double)0.0, (double)19.0, (double)9.5, (double)0.5, (double)25.0), Block.box((double)7.0, (double)0.0, (double)-7.0, (double)9.5, (double)0.5, (double)-1.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)-16.0, (double)31.0, (double)9.0, (double)32.0, (double)32.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-15.0, (double)4.0, (double)9.0, (double)31.0, (double)32.0, (double)10.5), Block.box((double)31.0, (double)5.0, (double)9.0, (double)32.0, (double)32.0, (double)11.0), Block.box((double)-16.0, (double)3.0, (double)9.0, (double)32.0, (double)7.0, (double)11.0), Block.box((double)-16.0, (double)5.0, (double)9.0, (double)-15.0, (double)32.0, (double)11.0), Block.box((double)18.0, (double)0.5, (double)7.0, (double)22.0, (double)19.0, (double)9.5), Block.box((double)-8.0, (double)0.5, (double)7.0, (double)-4.0, (double)19.0, (double)9.5), Block.box((double)-2.0, (double)13.0, (double)8.0, (double)16.0, (double)27.0, (double)9.5), Block.box((double)-9.0, (double)0.0, (double)7.0, (double)-3.0, (double)0.5, (double)9.5), Block.box((double)17.0, (double)0.0, (double)7.0, (double)23.0, (double)0.5, (double)9.5)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)31.0, (double)-16.0, (double)7.0, (double)32.0, (double)32.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)4.0, (double)-15.0, (double)7.0, (double)32.0, (double)31.0), Block.box((double)5.0, (double)5.0, (double)31.0, (double)7.0, (double)32.0, (double)32.0), Block.box((double)5.0, (double)3.0, (double)-16.0, (double)7.0, (double)7.0, (double)32.0), Block.box((double)5.0, (double)5.0, (double)-16.0, (double)7.0, (double)32.0, (double)-15.0), Block.box((double)6.5, (double)0.5, (double)18.0, (double)9.0, (double)19.0, (double)22.0), Block.box((double)6.5, (double)0.5, (double)-8.0, (double)9.0, (double)19.0, (double)-4.0), Block.box((double)6.5, (double)13.0, (double)-2.0, (double)8.0, (double)27.0, (double)16.0), Block.box((double)6.5, (double)0.0, (double)-9.0, (double)9.0, (double)0.5, (double)-3.0), Block.box((double)6.5, (double)0.0, (double)17.0, (double)9.0, (double)0.5, (double)23.0)});

    public MacMaxXBlock() {
        this(BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).strength(6.0f).sound(SoundType.METAL).noOcclusion().dynamicShape());
    }

    public MacMaxXBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
        };
    }

    public float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1.0f;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return this.canPlace(context.getLevel(), context.getClickedPos(), context.getHorizontalDirection(), context.getHand(), context.getItemInHand()) ? super.getStateForPlacement(context) : null;
    }

    public boolean canPlace(Level level, BlockPos pos, Direction face, InteractionHand hand, ItemStack itemInHand) {
        this.hasBlock(level, pos.above(), hand, itemInHand, face);
        switch (face) {
            case NORTH: {
                if (this.hasBlock(level, pos.above().west(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above().east(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.west(), hand, itemInHand, face)) {
                    return false;
                }
                if (!this.hasBlock(level, pos.east(), hand, itemInHand, face)) break;
                return false;
            }
            case SOUTH: {
                if (this.hasBlock(level, pos.above().east(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above().west(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.east(), hand, itemInHand, face)) {
                    return false;
                }
                if (!this.hasBlock(level, pos.west(), hand, itemInHand, face)) break;
                return false;
            }
            case WEST: {
                if (this.hasBlock(level, pos.above().north(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above().south(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.north(), hand, itemInHand, face)) {
                    return false;
                }
                if (!this.hasBlock(level, pos.south(), hand, itemInHand, face)) break;
                return false;
            }
            case EAST: {
                if (this.hasBlock(level, pos.above().south(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above().north(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.above(), hand, itemInHand, face)) {
                    return false;
                }
                if (this.hasBlock(level, pos.south(), hand, itemInHand, face)) {
                    return false;
                }
                if (!this.hasBlock(level, pos.north(), hand, itemInHand, face)) break;
                return false;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(face));
            }
        }
        return true;
    }

    private boolean hasBlock(Level level, BlockPos pos, InteractionHand hand, ItemStack itemInHand, Direction face) {
        return !level.getBlockState(pos).isAir() && !level.getBlockState(pos).canBeReplaced((BlockPlaceContext)new FakeBlockPlaceContext(level, hand, itemInHand, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), face, pos, false)));
    }

    @Override
    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        if (state.isAir()) {
            return;
        }
        BlockState partState = ((MacMaxXBlockPart)((Object)DeviceBlocks.MAC_MAX_X_PART.get())).defaultBlockState();
        partState = (BlockState)partState.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        level.setBlock(pos.above(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.T)), 3);
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                level.setBlock(pos.above().west(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TL)), 3);
                level.setBlock(pos.above().east(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TR)), 3);
                level.setBlock(pos.west(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BL)), 3);
                level.setBlock(pos.east(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BR)), 3);
                break;
            }
            case SOUTH: {
                level.setBlock(pos.above().east(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TL)), 3);
                level.setBlock(pos.above().west(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TR)), 3);
                level.setBlock(pos.east(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BL)), 3);
                level.setBlock(pos.west(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BR)), 3);
                break;
            }
            case WEST: {
                level.setBlock(pos.above().north(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TL)), 3);
                level.setBlock(pos.above().south(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TR)), 3);
                level.setBlock(pos.north(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BL)), 3);
                level.setBlock(pos.south(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BR)), 3);
                break;
            }
            case EAST: {
                level.setBlock(pos.above().south(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TL)), 3);
                level.setBlock(pos.above().north(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.TR)), 3);
                level.setBlock(pos.south(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BL)), 3);
                level.setBlock(pos.north(), (BlockState)partState.setValue(MacMaxXBlockPart.PART, (Comparable)((Object)MacMaxXBlockPart.Part.BR)), 3);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(state.getValue((Property)FACING)));
            }
        }
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                level.setBlock(pos.above().west(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above().east(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.west(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.east(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            case SOUTH: {
                level.setBlock(pos.above().east(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above().west(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.east(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.west(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            case WEST: {
                level.setBlock(pos.above().north(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above().south(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.north(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.south(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            case EAST: {
                level.setBlock(pos.above().south(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above().north(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.south(), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.north(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(state.getValue((Property)FACING)));
            }
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean isDesktopPC() {
        return true;
    }

    @NotNull
    public MutableComponent getName() {
        MutableComponent normalName = Component.translatable((String)"block.devices.mac_max_x");
        if (XinexPlatform.isModLoaded((String)"emojiful")) {
            return Component.translatable((String)"block.devices.mac_max_x_emoji");
        }
        return normalName;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MacMaxXBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

