/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.computer;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.block.computer.MacMaxXBlock;
import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MacMaxXBlockPart
extends HorizontalDirectionalBlock {
    public static final MapCodec<MacMaxXBlockPart> CODEC = MacMaxXBlockPart.simpleCodec(MacMaxXBlockPart::new);
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    private static final VoxelShape BL_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)31.0, (double)5.0, (double)48.0, (double)32.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)4.0, (double)5.5, (double)47.0, (double)32.0, (double)7.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)32.0, (double)7.0), Block.box((double)0.0, (double)3.0, (double)5.0, (double)48.0, (double)7.0, (double)7.0), Block.box((double)47.0, (double)5.0, (double)5.0, (double)48.0, (double)32.0, (double)7.0), Block.box((double)10.0, (double)0.5, (double)6.5, (double)14.0, (double)19.0, (double)9.0), Block.box((double)36.0, (double)0.5, (double)6.5, (double)40.0, (double)19.0, (double)9.0), Block.box((double)16.0, (double)13.0, (double)6.5, (double)34.0, (double)27.0, (double)8.0), Block.box((double)35.0, (double)0.0, (double)6.5, (double)41.0, (double)0.5, (double)9.0), Block.box((double)9.0, (double)0.0, (double)6.5, (double)15.0, (double)0.5, (double)9.0)});
    private static final VoxelShape BL_SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)31.0, (double)-32.0, (double)11.0, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)4.0, (double)-31.0, (double)10.5, (double)32.0, (double)15.0), Block.box((double)9.0, (double)5.0, (double)-32.0, (double)11.0, (double)32.0, (double)-31.0), Block.box((double)9.0, (double)3.0, (double)-32.0, (double)11.0, (double)7.0, (double)16.0), Block.box((double)9.0, (double)5.0, (double)15.0, (double)11.0, (double)32.0, (double)16.0), Block.box((double)7.0, (double)0.5, (double)-22.0, (double)9.5, (double)19.0, (double)-18.0), Block.box((double)7.0, (double)0.5, (double)4.0, (double)9.5, (double)19.0, (double)8.0), Block.box((double)8.0, (double)13.0, (double)-16.0, (double)9.5, (double)27.0, (double)2.0), Block.box((double)7.0, (double)0.0, (double)3.0, (double)9.5, (double)0.5, (double)9.0), Block.box((double)7.0, (double)0.0, (double)-23.0, (double)9.5, (double)0.5, (double)-17.0)});
    private static final VoxelShape BL_SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)-32.0, (double)31.0, (double)9.0, (double)16.0, (double)32.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-31.0, (double)4.0, (double)9.0, (double)15.0, (double)32.0, (double)10.5), Block.box((double)15.0, (double)5.0, (double)9.0, (double)16.0, (double)32.0, (double)11.0), Block.box((double)-32.0, (double)3.0, (double)9.0, (double)16.0, (double)7.0, (double)11.0), Block.box((double)-32.0, (double)5.0, (double)9.0, (double)-31.0, (double)32.0, (double)11.0), Block.box((double)2.0, (double)0.5, (double)7.0, (double)6.0, (double)19.0, (double)9.5), Block.box((double)-24.0, (double)0.5, (double)7.0, (double)-20.0, (double)19.0, (double)9.5), Block.box((double)-18.0, (double)13.0, (double)8.0, (double)0.0, (double)27.0, (double)9.5), Block.box((double)-25.0, (double)0.0, (double)7.0, (double)-19.0, (double)0.5, (double)9.5), Block.box((double)1.0, (double)0.0, (double)7.0, (double)7.0, (double)0.5, (double)9.5)});
    private static final VoxelShape BL_SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)31.0, (double)0.0, (double)7.0, (double)32.0, (double)48.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)4.0, (double)1.0, (double)7.0, (double)32.0, (double)47.0), Block.box((double)5.0, (double)5.0, (double)47.0, (double)7.0, (double)32.0, (double)48.0), Block.box((double)5.0, (double)3.0, (double)0.0, (double)7.0, (double)7.0, (double)48.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)7.0, (double)32.0, (double)1.0), Block.box((double)6.5, (double)0.5, (double)34.0, (double)9.0, (double)19.0, (double)38.0), Block.box((double)6.5, (double)0.5, (double)8.0, (double)9.0, (double)19.0, (double)12.0), Block.box((double)6.5, (double)13.0, (double)14.0, (double)8.0, (double)27.0, (double)32.0), Block.box((double)6.5, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)13.0), Block.box((double)6.5, (double)0.0, (double)33.0, (double)9.0, (double)0.5, (double)39.0)});
    private static final VoxelShape BR_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)-32.0, (double)31.0, (double)5.0, (double)16.0, (double)32.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-31.0, (double)4.0, (double)5.5, (double)15.0, (double)32.0, (double)7.0), Block.box((double)-32.0, (double)5.0, (double)5.0, (double)-31.0, (double)32.0, (double)7.0), Block.box((double)-32.0, (double)3.0, (double)5.0, (double)16.0, (double)7.0, (double)7.0), Block.box((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)32.0, (double)7.0), Block.box((double)-22.0, (double)0.5, (double)6.5, (double)-18.0, (double)19.0, (double)9.0), Block.box((double)4.0, (double)0.5, (double)6.5, (double)8.0, (double)19.0, (double)9.0), Block.box((double)-16.0, (double)13.0, (double)6.5, (double)2.0, (double)27.0, (double)8.0), Block.box((double)3.0, (double)0.0, (double)6.5, (double)9.0, (double)0.5, (double)9.0), Block.box((double)-23.0, (double)0.0, (double)6.5, (double)-17.0, (double)0.5, (double)9.0)});
    private static final VoxelShape BR_SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)31.0, (double)0.0, (double)11.0, (double)32.0, (double)48.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)4.0, (double)1.0, (double)10.5, (double)32.0, (double)47.0), Block.box((double)9.0, (double)5.0, (double)0.0, (double)11.0, (double)32.0, (double)1.0), Block.box((double)9.0, (double)3.0, (double)0.0, (double)11.0, (double)7.0, (double)48.0), Block.box((double)9.0, (double)5.0, (double)47.0, (double)11.0, (double)32.0, (double)48.0), Block.box((double)7.0, (double)0.5, (double)10.0, (double)9.5, (double)19.0, (double)14.0), Block.box((double)7.0, (double)0.5, (double)36.0, (double)9.5, (double)19.0, (double)40.0), Block.box((double)8.0, (double)13.0, (double)16.0, (double)9.5, (double)27.0, (double)34.0), Block.box((double)7.0, (double)0.0, (double)35.0, (double)9.5, (double)0.5, (double)41.0), Block.box((double)7.0, (double)0.0, (double)9.0, (double)9.5, (double)0.5, (double)15.0)});
    private static final VoxelShape BR_SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)31.0, (double)9.0, (double)48.0, (double)32.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)4.0, (double)9.0, (double)47.0, (double)32.0, (double)10.5), Block.box((double)47.0, (double)5.0, (double)9.0, (double)48.0, (double)32.0, (double)11.0), Block.box((double)0.0, (double)3.0, (double)9.0, (double)48.0, (double)7.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)9.0, (double)1.0, (double)32.0, (double)11.0), Block.box((double)34.0, (double)0.5, (double)7.0, (double)38.0, (double)19.0, (double)9.5), Block.box((double)8.0, (double)0.5, (double)7.0, (double)12.0, (double)19.0, (double)9.5), Block.box((double)14.0, (double)13.0, (double)8.0, (double)32.0, (double)27.0, (double)9.5), Block.box((double)7.0, (double)0.0, (double)7.0, (double)13.0, (double)0.5, (double)9.5), Block.box((double)33.0, (double)0.0, (double)7.0, (double)39.0, (double)0.5, (double)9.5)});
    private static final VoxelShape BR_SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)31.0, (double)-32.0, (double)7.0, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)4.0, (double)-31.0, (double)7.0, (double)32.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)15.0, (double)7.0, (double)32.0, (double)16.0), Block.box((double)5.0, (double)3.0, (double)-32.0, (double)7.0, (double)7.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)-32.0, (double)7.0, (double)32.0, (double)-31.0), Block.box((double)6.5, (double)0.5, (double)2.0, (double)9.0, (double)19.0, (double)6.0), Block.box((double)6.5, (double)0.5, (double)-24.0, (double)9.0, (double)19.0, (double)-20.0), Block.box((double)6.5, (double)13.0, (double)-18.0, (double)8.0, (double)27.0, (double)0.0), Block.box((double)6.5, (double)0.0, (double)-25.0, (double)9.0, (double)0.5, (double)-19.0), Block.box((double)6.5, (double)0.0, (double)1.0, (double)9.0, (double)0.5, (double)7.0)});
    private static final VoxelShape TL_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)15.0, (double)5.0, (double)48.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)-12.0, (double)5.5, (double)47.0, (double)16.0, (double)7.0), Block.box((double)0.0, (double)-11.0, (double)5.0, (double)1.0, (double)16.0, (double)7.0), Block.box((double)0.0, (double)-13.0, (double)5.0, (double)48.0, (double)-9.0, (double)7.0), Block.box((double)47.0, (double)-11.0, (double)5.0, (double)48.0, (double)16.0, (double)7.0), Block.box((double)10.0, (double)-15.5, (double)6.5, (double)14.0, (double)3.0, (double)9.0), Block.box((double)36.0, (double)-15.5, (double)6.5, (double)40.0, (double)3.0, (double)9.0), Block.box((double)16.0, (double)-3.0, (double)6.5, (double)34.0, (double)11.0, (double)8.0), Block.box((double)35.0, (double)-16.0, (double)6.5, (double)41.0, (double)-15.5, (double)9.0), Block.box((double)9.0, (double)-16.0, (double)6.5, (double)15.0, (double)-15.5, (double)9.0)});
    private static final VoxelShape TL_SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)15.0, (double)-32.0, (double)11.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)-12.0, (double)-31.0, (double)10.5, (double)16.0, (double)15.0), Block.box((double)9.0, (double)-11.0, (double)-32.0, (double)11.0, (double)16.0, (double)-31.0), Block.box((double)9.0, (double)-13.0, (double)-32.0, (double)11.0, (double)-9.0, (double)16.0), Block.box((double)9.0, (double)-11.0, (double)15.0, (double)11.0, (double)16.0, (double)16.0), Block.box((double)7.0, (double)-15.5, (double)-22.0, (double)9.5, (double)3.0, (double)-18.0), Block.box((double)7.0, (double)-15.5, (double)4.0, (double)9.5, (double)3.0, (double)8.0), Block.box((double)8.0, (double)-3.0, (double)-16.0, (double)9.5, (double)11.0, (double)2.0), Block.box((double)7.0, (double)-16.0, (double)3.0, (double)9.5, (double)-15.5, (double)9.0), Block.box((double)7.0, (double)-16.0, (double)-23.0, (double)9.5, (double)-15.5, (double)-17.0)});
    private static final VoxelShape TL_SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)-32.0, (double)15.0, (double)9.0, (double)16.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-31.0, (double)-12.0, (double)9.0, (double)15.0, (double)16.0, (double)10.5), Block.box((double)15.0, (double)-11.0, (double)9.0, (double)16.0, (double)16.0, (double)11.0), Block.box((double)-32.0, (double)-13.0, (double)9.0, (double)16.0, (double)-9.0, (double)11.0), Block.box((double)-32.0, (double)-11.0, (double)9.0, (double)-31.0, (double)16.0, (double)11.0), Block.box((double)2.0, (double)-15.5, (double)7.0, (double)6.0, (double)3.0, (double)9.5), Block.box((double)-24.0, (double)-15.5, (double)7.0, (double)-20.0, (double)3.0, (double)9.5), Block.box((double)-18.0, (double)-3.0, (double)8.0, (double)0.0, (double)11.0, (double)9.5), Block.box((double)-25.0, (double)-16.0, (double)7.0, (double)-19.0, (double)-15.5, (double)9.5), Block.box((double)1.0, (double)-16.0, (double)7.0, (double)7.0, (double)-15.5, (double)9.5)});
    private static final VoxelShape TL_SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)15.0, (double)0.0, (double)7.0, (double)16.0, (double)48.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)-12.0, (double)1.0, (double)7.0, (double)16.0, (double)47.0), Block.box((double)5.0, (double)-11.0, (double)47.0, (double)7.0, (double)16.0, (double)48.0), Block.box((double)5.0, (double)-13.0, (double)0.0, (double)7.0, (double)-9.0, (double)48.0), Block.box((double)5.0, (double)-11.0, (double)0.0, (double)7.0, (double)16.0, (double)1.0), Block.box((double)6.5, (double)-15.5, (double)34.0, (double)9.0, (double)3.0, (double)38.0), Block.box((double)6.5, (double)-15.5, (double)8.0, (double)9.0, (double)3.0, (double)12.0), Block.box((double)6.5, (double)-3.0, (double)14.0, (double)8.0, (double)11.0, (double)32.0), Block.box((double)6.5, (double)-16.0, (double)7.0, (double)9.0, (double)-15.5, (double)13.0), Block.box((double)6.5, (double)-16.0, (double)33.0, (double)9.0, (double)-15.5, (double)39.0)});
    private static final VoxelShape T_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)-16.0, (double)15.0, (double)5.0, (double)32.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-15.0, (double)-12.0, (double)5.5, (double)31.0, (double)16.0, (double)7.0), Block.box((double)-16.0, (double)-11.0, (double)5.0, (double)-15.0, (double)16.0, (double)7.0), Block.box((double)-16.0, (double)-13.0, (double)5.0, (double)32.0, (double)-9.0, (double)7.0), Block.box((double)31.0, (double)-11.0, (double)5.0, (double)32.0, (double)16.0, (double)7.0), Block.box((double)-6.0, (double)-15.5, (double)6.5, (double)-2.0, (double)3.0, (double)9.0), Block.box((double)20.0, (double)-15.5, (double)6.5, (double)24.0, (double)3.0, (double)9.0), Block.box((double)0.0, (double)-3.0, (double)6.5, (double)18.0, (double)11.0, (double)8.0), Block.box((double)19.0, (double)-16.0, (double)6.5, (double)25.0, (double)-15.5, (double)9.0), Block.box((double)-7.0, (double)-16.0, (double)6.5, (double)-1.0, (double)-15.5, (double)9.0)});
    private static final VoxelShape T_SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)15.0, (double)-16.0, (double)11.0, (double)16.0, (double)32.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)-12.0, (double)-15.0, (double)10.5, (double)16.0, (double)31.0), Block.box((double)9.0, (double)-11.0, (double)-16.0, (double)11.0, (double)16.0, (double)-15.0), Block.box((double)9.0, (double)-13.0, (double)-16.0, (double)11.0, (double)-9.0, (double)32.0), Block.box((double)9.0, (double)-11.0, (double)31.0, (double)11.0, (double)16.0, (double)32.0), Block.box((double)7.0, (double)-15.5, (double)-6.0, (double)9.5, (double)3.0, (double)-2.0), Block.box((double)7.0, (double)-15.5, (double)20.0, (double)9.5, (double)3.0, (double)24.0), Block.box((double)8.0, (double)-3.0, (double)0.0, (double)9.5, (double)11.0, (double)18.0), Block.box((double)7.0, (double)-16.0, (double)19.0, (double)9.5, (double)-15.5, (double)25.0), Block.box((double)7.0, (double)-16.0, (double)-7.0, (double)9.5, (double)-15.5, (double)-1.0)});
    private static final VoxelShape T_SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)-16.0, (double)15.0, (double)9.0, (double)32.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-15.0, (double)-12.0, (double)9.0, (double)31.0, (double)16.0, (double)10.5), Block.box((double)31.0, (double)-11.0, (double)9.0, (double)32.0, (double)16.0, (double)11.0), Block.box((double)-16.0, (double)-13.0, (double)9.0, (double)32.0, (double)-9.0, (double)11.0), Block.box((double)-16.0, (double)-11.0, (double)9.0, (double)-15.0, (double)16.0, (double)11.0), Block.box((double)18.0, (double)-15.5, (double)7.0, (double)22.0, (double)3.0, (double)9.5), Block.box((double)-8.0, (double)-15.5, (double)7.0, (double)-4.0, (double)3.0, (double)9.5), Block.box((double)-2.0, (double)-3.0, (double)8.0, (double)16.0, (double)11.0, (double)9.5), Block.box((double)-9.0, (double)-16.0, (double)7.0, (double)-3.0, (double)-15.5, (double)9.5), Block.box((double)17.0, (double)-16.0, (double)7.0, (double)23.0, (double)-15.5, (double)9.5)});
    private static final VoxelShape T_SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)15.0, (double)-16.0, (double)7.0, (double)16.0, (double)32.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)-12.0, (double)-15.0, (double)7.0, (double)16.0, (double)31.0), Block.box((double)5.0, (double)-11.0, (double)31.0, (double)7.0, (double)16.0, (double)32.0), Block.box((double)5.0, (double)-13.0, (double)-16.0, (double)7.0, (double)-9.0, (double)32.0), Block.box((double)5.0, (double)-11.0, (double)-16.0, (double)7.0, (double)16.0, (double)-15.0), Block.box((double)6.5, (double)-15.5, (double)18.0, (double)9.0, (double)3.0, (double)22.0), Block.box((double)6.5, (double)-15.5, (double)-8.0, (double)9.0, (double)3.0, (double)-4.0), Block.box((double)6.5, (double)-3.0, (double)-2.0, (double)8.0, (double)11.0, (double)16.0), Block.box((double)6.5, (double)-16.0, (double)-9.0, (double)9.0, (double)-15.5, (double)-3.0), Block.box((double)6.5, (double)-16.0, (double)17.0, (double)9.0, (double)-15.5, (double)23.0)});
    private static final VoxelShape TR_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)-32.0, (double)15.0, (double)5.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-31.0, (double)-12.0, (double)5.5, (double)15.0, (double)16.0, (double)7.0), Block.box((double)-32.0, (double)-11.0, (double)5.0, (double)-31.0, (double)16.0, (double)7.0), Block.box((double)-32.0, (double)-13.0, (double)5.0, (double)16.0, (double)-9.0, (double)7.0), Block.box((double)15.0, (double)-11.0, (double)5.0, (double)16.0, (double)16.0, (double)7.0), Block.box((double)-22.0, (double)-15.5, (double)6.5, (double)-18.0, (double)3.0, (double)9.0), Block.box((double)4.0, (double)-15.5, (double)6.5, (double)8.0, (double)3.0, (double)9.0), Block.box((double)-16.0, (double)-3.0, (double)6.5, (double)2.0, (double)11.0, (double)8.0), Block.box((double)3.0, (double)-16.0, (double)6.5, (double)9.0, (double)-15.5, (double)9.0), Block.box((double)-23.0, (double)-16.0, (double)6.5, (double)-17.0, (double)-15.5, (double)9.0)});
    private static final VoxelShape TR_SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)15.0, (double)0.0, (double)11.0, (double)16.0, (double)48.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)-12.0, (double)1.0, (double)10.5, (double)16.0, (double)47.0), Block.box((double)9.0, (double)-11.0, (double)0.0, (double)11.0, (double)16.0, (double)1.0), Block.box((double)9.0, (double)-13.0, (double)0.0, (double)11.0, (double)-9.0, (double)48.0), Block.box((double)9.0, (double)-11.0, (double)47.0, (double)11.0, (double)16.0, (double)48.0), Block.box((double)7.0, (double)-15.5, (double)10.0, (double)9.5, (double)3.0, (double)14.0), Block.box((double)7.0, (double)-15.5, (double)36.0, (double)9.5, (double)3.0, (double)40.0), Block.box((double)8.0, (double)-3.0, (double)16.0, (double)9.5, (double)11.0, (double)34.0), Block.box((double)7.0, (double)-16.0, (double)35.0, (double)9.5, (double)-15.5, (double)41.0), Block.box((double)7.0, (double)-16.0, (double)9.0, (double)9.5, (double)-15.5, (double)15.0)});
    private static final VoxelShape TR_SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)15.0, (double)9.0, (double)48.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)-12.0, (double)9.0, (double)47.0, (double)16.0, (double)10.5), Block.box((double)47.0, (double)-11.0, (double)9.0, (double)48.0, (double)16.0, (double)11.0), Block.box((double)0.0, (double)-13.0, (double)9.0, (double)48.0, (double)-9.0, (double)11.0), Block.box((double)0.0, (double)-11.0, (double)9.0, (double)1.0, (double)16.0, (double)11.0), Block.box((double)34.0, (double)-15.5, (double)7.0, (double)38.0, (double)3.0, (double)9.5), Block.box((double)8.0, (double)-15.5, (double)7.0, (double)12.0, (double)3.0, (double)9.5), Block.box((double)14.0, (double)-3.0, (double)8.0, (double)32.0, (double)11.0, (double)9.5), Block.box((double)7.0, (double)-16.0, (double)7.0, (double)13.0, (double)-15.5, (double)9.5), Block.box((double)33.0, (double)-16.0, (double)7.0, (double)39.0, (double)-15.5, (double)9.5)});
    private static final VoxelShape TR_SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)15.0, (double)-32.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)-12.0, (double)-31.0, (double)7.0, (double)16.0, (double)15.0), Block.box((double)5.0, (double)-11.0, (double)15.0, (double)7.0, (double)16.0, (double)16.0), Block.box((double)5.0, (double)-13.0, (double)-32.0, (double)7.0, (double)-9.0, (double)16.0), Block.box((double)5.0, (double)-11.0, (double)-32.0, (double)7.0, (double)16.0, (double)-31.0), Block.box((double)6.5, (double)-15.5, (double)2.0, (double)9.0, (double)3.0, (double)6.0), Block.box((double)6.5, (double)-15.5, (double)-24.0, (double)9.0, (double)3.0, (double)-20.0), Block.box((double)6.5, (double)-3.0, (double)-18.0, (double)8.0, (double)11.0, (double)0.0), Block.box((double)6.5, (double)-16.0, (double)-25.0, (double)9.0, (double)-15.5, (double)-19.0), Block.box((double)6.5, (double)-16.0, (double)1.0, (double)9.0, (double)-15.5, (double)7.0)});

    public MacMaxXBlockPart() {
        this(BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).strength(6.0f).sound(SoundType.METAL));
    }

    public MacMaxXBlockPart(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.T)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        switch (((Part)((Object)pState.getValue(PART))).ordinal()) {
            case 0: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    case Direction.NORTH -> BL_SHAPE_NORTH;
                    case Direction.EAST -> BL_SHAPE_EAST;
                    case Direction.SOUTH -> BL_SHAPE_SOUTH;
                    case Direction.WEST -> BL_SHAPE_WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                };
            }
            case 1: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    case Direction.NORTH -> BR_SHAPE_NORTH;
                    case Direction.EAST -> BR_SHAPE_EAST;
                    case Direction.SOUTH -> BR_SHAPE_SOUTH;
                    case Direction.WEST -> BR_SHAPE_WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                };
            }
            case 2: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    case Direction.NORTH -> TL_SHAPE_NORTH;
                    case Direction.EAST -> TL_SHAPE_EAST;
                    case Direction.SOUTH -> TL_SHAPE_SOUTH;
                    case Direction.WEST -> TL_SHAPE_WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                };
            }
            case 3: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    case Direction.NORTH -> T_SHAPE_NORTH;
                    case Direction.EAST -> T_SHAPE_EAST;
                    case Direction.SOUTH -> T_SHAPE_SOUTH;
                    case Direction.WEST -> T_SHAPE_WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                };
            }
            case 4: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    case Direction.NORTH -> TR_SHAPE_NORTH;
                    case Direction.EAST -> TR_SHAPE_EAST;
                    case Direction.SOUTH -> TR_SHAPE_SOUTH;
                    case Direction.WEST -> TR_SHAPE_WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
                };
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue(PART)));
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos originPos = MacMaxXBlockPart.getOriginPos(pos, state);
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                this.destroyBlockExcept(level, pos, originPos.above().west(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above().east(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.west(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.east(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            case SOUTH: {
                this.destroyBlockExcept(level, pos, originPos.above().east(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above().west(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.east(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.west(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            case WEST: {
                this.destroyBlockExcept(level, pos, originPos.above().north(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above().south(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.north(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.south(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            case EAST: {
                this.destroyBlockExcept(level, pos, originPos.above().south(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above().north(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.above(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.south(), Blocks.AIR.defaultBlockState(), 3);
                this.destroyBlockExcept(level, pos, originPos.north(), Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(state.getValue((Property)FACING)));
            }
        }
        this.destroyBlockExcept(level, pos, originPos, Blocks.AIR.defaultBlockState(), 3);
        return Blocks.AIR.defaultBlockState();
    }

    private void destroyBlockExcept(Level level, BlockPos except, BlockPos pos, BlockState state, int flags) {
        if (except.equals((Object)pos)) {
            return;
        }
        level.setBlock(pos, state, flags);
    }

    private static BlockPos getOriginPos(@NotNull BlockPos pos, BlockState state) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                switch (((Part)((Object)state.getValue(PART))).ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield pos.east().below();
                    }
                    case 4: {
                        yield pos.west().below();
                    }
                    case 3: {
                        yield pos.below();
                    }
                    case 0: {
                        yield pos.east();
                    }
                    case 1: 
                }
                yield pos.west();
            }
            case Direction.SOUTH -> {
                switch (((Part)((Object)state.getValue(PART))).ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield pos.west().below();
                    }
                    case 4: {
                        yield pos.east().below();
                    }
                    case 3: {
                        yield pos.below();
                    }
                    case 0: {
                        yield pos.west();
                    }
                    case 1: 
                }
                yield pos.east();
            }
            case Direction.WEST -> {
                switch (((Part)((Object)state.getValue(PART))).ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield pos.south().below();
                    }
                    case 4: {
                        yield pos.north().below();
                    }
                    case 3: {
                        yield pos.below();
                    }
                    case 0: {
                        yield pos.south();
                    }
                    case 1: 
                }
                yield pos.north();
            }
            case Direction.EAST -> {
                switch (((Part)((Object)state.getValue(PART))).ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield pos.north().below();
                    }
                    case 4: {
                        yield pos.south().below();
                    }
                    case 3: {
                        yield pos.below();
                    }
                    case 0: {
                        yield pos.north();
                    }
                    case 1: 
                }
                yield pos.south();
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(state.getValue((Property)FACING)));
        };
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockPos originPos = MacMaxXBlockPart.getOriginPos(pos, state);
        BlockState originState = level.getBlockState(originPos);
        Block block = originState.getBlock();
        if (block instanceof MacMaxXBlock) {
            MacMaxXBlock block2 = (MacMaxXBlock)block;
            return block2.useWithoutItem(originState, level, originPos, player, hitResult);
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public MutableComponent getName() {
        MutableComponent normalName = Component.translatable((String)"block.devices.mac_max_x");
        if (XinexPlatform.isModLoaded((String)"emojiful")) {
            return Component.translatable((String)"block.devices.mac_max_x_emoji");
        }
        return normalName;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{PART, FACING});
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static enum Part implements StringRepresentable
    {
        BL,
        BR,
        TL,
        T,
        TR;


        @NotNull
        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "bottom_left";
                case 1 -> "bottom_right";
                case 2 -> "top_left";
                case 3 -> "top";
                case 4 -> "top_right";
            };
        }
    }
}

