/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.SyncBlockEntity;
import dev.ultreon.devices.util.Colorable;
import dev.ultreon.devices.util.Tickable;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class DeviceBlockEntity
extends SyncBlockEntity
implements Tickable {
    private DyeColor color = DyeColor.RED;
    private UUID deviceId;
    private String name;

    public DeviceBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @NotNull
    public final UUID getId() {
        if (this.deviceId == null) {
            this.deviceId = UUID.randomUUID();
        }
        return this.deviceId;
    }

    public abstract String getDeviceName();

    public String getCustomName() {
        return this.hasCustomName() ? this.name : this.getDeviceName();
    }

    public void setCustomName(String name) {
        this.name = name;
    }

    public boolean hasCustomName() {
        return this.name != null && StringUtils.isEmpty((CharSequence)this.name);
    }

    public Component getDisplayName() {
        return Component.literal((String)this.getCustomName());
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("deviceId", this.getId().toString());
        if (this.hasCustomName()) {
            tag.putString("name", this.name);
        }
        tag.putByte("color", (byte)this.color.getId());
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("deviceId", 8)) {
            this.deviceId = UUID.fromString(tag.getString("deviceId"));
        }
        if (tag.contains("name", 8)) {
            this.name = tag.getString("name");
        }
        if (tag.contains("color", 1)) {
            this.color = DyeColor.byId((int)tag.getByte("color"));
        }
    }

    @Override
    public CompoundTag saveSyncTag() {
        CompoundTag tag = new CompoundTag();
        if (this.hasCustomName()) {
            tag.putString("name", this.name);
        }
        tag.putByte("color", (byte)this.color.getId());
        return tag;
    }

    public Block getBlock() {
        return this.getBlockState().getBlock();
    }

    public DeviceBlock getDeviceBlock() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof DeviceBlock) {
            DeviceBlock deviceBlock = (DeviceBlock)block;
            return deviceBlock;
        }
        return null;
    }

    public static abstract class Colored
    extends DeviceBlockEntity
    implements Colorable {
        private DyeColor color = DyeColor.RED;

        public Colored(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
            super(pType, pWorldPosition, pBlockState);
        }

        @Override
        public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
            super.loadAdditional(tag, provider);
            if (tag.contains("color", 1)) {
                this.color = DyeColor.byId((int)tag.getByte("color"));
            }
        }

        @Override
        protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
            super.saveAdditional(tag, provider);
            tag.putByte("color", (byte)this.color.getId());
        }

        @Override
        public CompoundTag saveSyncTag() {
            CompoundTag tag = super.saveSyncTag();
            tag.putByte("color", (byte)this.color.getId());
            return tag;
        }

        @Override
        public DyeColor getColor() {
            return this.color;
        }

        @Override
        public void setColor(DyeColor color) {
            this.color = color;
        }
    }
}

