/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.block.entity.DeviceBlockEntity;
import dev.ultreon.devices.core.network.Connection;
import dev.ultreon.devices.core.network.Router;
import dev.ultreon.devices.util.Colorable;
import dev.ultreon.devices.util.Tickable;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NetworkDeviceBlockEntity
extends DeviceBlockEntity
implements Tickable {
    private int counter;
    private Connection connection;

    public NetworkDeviceBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        if (this.connection != null && ++this.counter >= (Integer)DeviceConfig.BEACON_INTERVAL.get() * 2) {
            this.connection.setRouterPos(null);
            this.counter = 0;
        }
    }

    public void connect(Router router) {
        assert (this.level != null);
        if (router == null) {
            Router connectedRouter;
            if (this.connection != null && (connectedRouter = this.connection.getRouter(this.level)) != null) {
                connectedRouter.removeDevice(this);
            }
            this.connection = null;
            return;
        }
        this.connection = new Connection(router);
        this.counter = 0;
        this.setChanged();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Nullable
    public Router getRouter() {
        return this.connection != null ? this.connection.getRouter(Objects.requireNonNull(this.level)) : null;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public boolean receiveBeacon(Router router) {
        if (this.counter >= (Integer)DeviceConfig.BEACON_INTERVAL.get() * 2) {
            this.connect(router);
            return true;
        }
        if (this.connection != null && this.connection.getRouterId().equals(router.getId())) {
            this.connection.setRouterPos(router.getPos());
            this.counter = 0;
            return true;
        }
        return false;
    }

    public int getSignalStrength() {
        BlockPos routerPos;
        BlockPos blockPos = routerPos = this.connection != null ? this.connection.getRouterPos() : null;
        if (routerPos != null) {
            double level;
            double distance = Math.sqrt(this.worldPosition.distToCenterSqr((double)routerPos.getX() + 0.5, (double)routerPos.getY() + 0.5, (double)routerPos.getZ() + 0.5));
            return distance > (level = (double)((Integer)DeviceConfig.SIGNAL_RANGE.get()).intValue() / 3.0) * 2.0 ? 2 : (distance > level ? 1 : 0);
        }
        return -1;
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        return Component.literal((String)this.getCustomName());
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.connection != null) {
            tag.put("connection", (Tag)this.connection.toTag());
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("connection", 10)) {
            this.connection = Connection.fromTag(tag.getCompound("connection"));
        }
    }

    public static abstract class Colored
    extends NetworkDeviceBlockEntity
    implements Colorable {
        private DyeColor color = DyeColor.RED;

        public Colored(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
            super(pType, pWorldPosition, pBlockState);
        }

        @Override
        public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
            super.loadAdditional(tag, provider);
            if (tag.contains("color", 8)) {
                this.color = DyeColor.byId((int)tag.getByte("color"));
            }
        }

        @Override
        public void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
            super.saveAdditional(tag, provider);
            tag.putByte("color", (byte)this.color.getId());
        }

        @Override
        public CompoundTag saveSyncTag() {
            CompoundTag tag = super.saveSyncTag();
            tag.putByte("color", (byte)this.color.getId());
            return tag;
        }

        @Override
        public void setColor(DyeColor color) {
            this.color = color;
        }

        @Override
        public DyeColor getColor() {
            return this.color;
        }
    }
}

