/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.block.computer.LaptopBlock;
import dev.ultreon.devices.block.entity.SyncBlockEntity;
import dev.ultreon.devices.entity.Seat;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.devices.util.Colorable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class OfficeChairBlockEntity
extends SyncBlockEntity
implements Colorable {
    private DyeColor color = DyeColor.RED;

    public OfficeChairBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)DeviceBlockEntities.SEAT.get(), pWorldPosition, pBlockState);
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(DyeColor color) {
        this.color = color;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("color", 1)) {
            this.color = DyeColor.byId((int)tag.getByte("color"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putByte("color", (byte)this.color.getId());
    }

    @Override
    public CompoundTag saveSyncTag() {
        CompoundTag tag = new CompoundTag();
        tag.putByte("color", (byte)this.color.getId());
        return tag;
    }

    public float getRotation() {
        Seat seat;
        List seats = this.level.getEntitiesOfClass(Seat.class, new AABB(this.getBlockPos()));
        if (!seats.isEmpty() && (seat = (Seat)((Object)seats.get(0))).getControllingPassenger() != null) {
            if (seat.getControllingPassenger() instanceof LivingEntity) {
                LivingEntity living = seat.getControllingPassenger();
                living.setYBodyRot(living.yHeadRot);
                return living.yHeadRot;
            }
            return seat.getControllingPassenger().getYHeadRot();
        }
        float direction = ((Direction)this.getBlockState().getValue((Property)LaptopBlock.FACING)).getClockWise().toYRot();
        return direction - 90.0f;
    }

    public float getRotation(float partialTick) {
        Seat seat;
        List seats = this.level.getEntitiesOfClass(Seat.class, new AABB(this.getBlockPos()));
        if (!seats.isEmpty() && (seat = (Seat)((Object)seats.get(0))).getControllingPassenger() != null) {
            if (seat.getControllingPassenger() instanceof LivingEntity) {
                LivingEntity living = seat.getControllingPassenger();
                living.setYBodyRot(living.yHeadRot);
                return living.yHeadRot;
            }
            return seat.getControllingPassenger().getViewYRot(partialTick);
        }
        float direction = ((Direction)this.getBlockState().getValue((Property)LaptopBlock.FACING)).getClockWise().toYRot();
        return direction - 90.0f;
    }
}

