/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.block.entity.SyncBlockEntity;
import dev.ultreon.devices.init.DeviceBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperBlockEntity
extends SyncBlockEntity {
    private IPrint print;
    private byte rotation;

    public PaperBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)DeviceBlockEntities.PAPER.get(), pWorldPosition, pBlockState);
    }

    public void nextRotation() {
        this.rotation = (byte)(this.rotation + 1);
        if (this.rotation > 7) {
            this.rotation = 0;
        }
        this.pipeline.putByte("rotation", this.rotation);
        this.sync();
        this.playSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM);
    }

    public float getRotation() {
        return (float)this.rotation * 45.0f;
    }

    @Nullable
    public IPrint getPrint() {
        return this.print;
    }

    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("print", 10)) {
            this.print = IPrint.load(compound.getCompound("print"));
        }
        if (compound.contains("rotation", 1)) {
            this.rotation = compound.getByte("rotation");
        }
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.print != null) {
            compound.put("print", (Tag)IPrint.save(this.print));
        }
        compound.putByte("rotation", this.rotation);
    }

    @Override
    public CompoundTag saveSyncTag() {
        CompoundTag tag = new CompoundTag();
        if (this.print != null) {
            tag.put("print", (Tag)IPrint.save(this.print));
        }
        tag.putByte("rotation", this.rotation);
        return tag;
    }

    private void playSound(SoundEvent sound) {
        if (this.level != null) {
            this.level.playSound(null, this.worldPosition, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

