/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.api.event.PrinterPrintQueuedEvent;
import dev.ultreon.devices.api.event.PrinterPrintedEvent;
import dev.ultreon.devices.api.event.PrinterStartPrintingEvent;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.devices.init.DeviceSounds;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PrinterBlockEntity
extends NetworkDeviceBlockEntity.Colored {
    private State state = State.IDLE;
    private final Deque<IPrint> printQueue = new ArrayDeque<IPrint>();
    private IPrint currentPrint;
    private int totalPrintTime;
    private int remainingPrintTime;
    private int paperCount = 0;

    public PrinterBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)DeviceBlockEntities.PRINTER.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            if (this.remainingPrintTime > 0) {
                if (this.remainingPrintTime % 20 == 0 || this.state == State.LOADING_PAPER) {
                    this.pipeline.putInt("remainingPrintTime", this.remainingPrintTime);
                    this.sync();
                    if (this.remainingPrintTime != 0 && this.state == State.PRINTING) {
                        this.level.playSound(null, this.worldPosition, (SoundEvent)DeviceSounds.PRINTER_PRINTING.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    }
                }
                --this.remainingPrintTime;
            } else {
                this.setState(this.state.next());
            }
        }
        if (this.state == State.IDLE && this.remainingPrintTime == 0 && this.currentPrint != null) {
            if (!this.level.isClientSide) {
                ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.0625, (double)this.worldPosition.getZ(), IPrint.generateItem(this.currentPrint));
                entity.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
                this.level.addFreshEntity((Entity)entity);
            }
            EventSystem.MAIN.publish((Object)new PrinterPrintedEvent(this, this.currentPrint));
            this.currentPrint = null;
        }
        if (this.state == State.IDLE && this.currentPrint == null && !this.printQueue.isEmpty() && this.paperCount > 0) {
            this.print(this.printQueue.poll());
        }
    }

    @Override
    public String getDeviceName() {
        return "Printer";
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("currentPrint", 10)) {
            this.currentPrint = IPrint.load(compound.getCompound("currentPrint"));
        }
        if (compound.contains("totalPrintTime", 3)) {
            this.totalPrintTime = compound.getInt("totalPrintTime");
        }
        if (compound.contains("remainingPrintTime", 3)) {
            this.remainingPrintTime = compound.getInt("remainingPrintTime");
        }
        if (compound.contains("state", 3)) {
            this.state = State.values()[compound.getInt("state")];
        }
        if (compound.contains("paperCount", 3)) {
            this.paperCount = compound.getInt("paperCount");
        }
        if (compound.contains("queue", 9)) {
            this.printQueue.clear();
            ListTag queue = compound.getList("queue", 10);
            for (int i = 0; i < queue.size(); ++i) {
                IPrint print = IPrint.load(queue.getCompound(i));
                this.printQueue.offer(print);
            }
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("totalPrintTime", this.totalPrintTime);
        tag.putInt("remainingPrintTime", this.remainingPrintTime);
        tag.putInt("state", this.state.ordinal());
        tag.putInt("paperCount", this.paperCount);
        if (this.currentPrint != null) {
            tag.put("currentPrint", (Tag)IPrint.save(this.currentPrint));
        }
        if (!this.printQueue.isEmpty()) {
            ListTag queue = new ListTag();
            this.printQueue.forEach(print -> queue.add((Object)IPrint.save(print)));
            tag.put("queue", (Tag)queue);
        }
    }

    @Override
    public CompoundTag saveSyncTag() {
        CompoundTag tag = super.saveSyncTag();
        tag.putInt("paperCount", this.paperCount);
        return tag;
    }

    public void setState(State newState) {
        if (newState == null) {
            return;
        }
        this.state = newState;
        this.remainingPrintTime = this.state == State.PRINTING ? (((Boolean)DeviceConfig.OVERRIDE_PRINT_SPEED.get()).booleanValue() ? (Integer)DeviceConfig.CUSTOM_PRINT_SPEED.get() * 20 : this.currentPrint.speed() * 20) : this.state.animationTime;
        this.totalPrintTime = this.remainingPrintTime;
        this.pipeline.putInt("state", this.state.ordinal());
        this.pipeline.putInt("totalPrintTime", this.totalPrintTime);
        this.pipeline.putInt("remainingPrintTime", this.remainingPrintTime);
        this.sync();
    }

    public void addToQueue(IPrint print) {
        EventSystem.MAIN.publish((Object)new PrinterPrintQueuedEvent(this, print));
        this.printQueue.offer(print);
    }

    private void print(IPrint print) {
        assert (this.level != null);
        this.level.playSound(null, this.worldPosition, (SoundEvent)DeviceSounds.PRINTER_LOADING_PAPER.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.setState(State.LOADING_PAPER);
        this.currentPrint = print;
        --this.paperCount;
        this.pipeline.putInt("paperCount", this.paperCount);
        this.pipeline.put("currentPrint", (Tag)IPrint.save(this.currentPrint));
        EventSystem.MAIN.publish((Object)new PrinterStartPrintingEvent(this, print));
        this.sync();
    }

    public boolean isLoading() {
        return this.state == State.LOADING_PAPER;
    }

    public boolean isPrinting() {
        return this.state == State.PRINTING;
    }

    public int getTotalPrintTime() {
        return this.totalPrintTime;
    }

    public int getRemainingPrintTime() {
        return this.remainingPrintTime;
    }

    public boolean addPaper(ItemStack stack, boolean addAll) {
        if (!stack.isEmpty() && stack.getItem() == Items.PAPER && this.paperCount < (Integer)DeviceConfig.MAX_PAPER_COUNT.get()) {
            if (!addAll) {
                ++this.paperCount;
                stack.shrink(1);
            } else {
                this.paperCount += stack.getCount();
                stack.setCount(Math.max(0, this.paperCount - 64));
                this.paperCount = Math.min(64, this.paperCount);
            }
            this.pipeline.putInt("paperCount", this.paperCount);
            this.sync();
            assert (this.level != null);
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean hasPaper() {
        return this.paperCount > 0;
    }

    public int getPaperCount() {
        return this.paperCount;
    }

    public IPrint getPrint() {
        return this.currentPrint;
    }

    public static enum State {
        LOADING_PAPER(30),
        PRINTING(0),
        IDLE(0);

        final int animationTime;

        private State(int time) {
            this.animationTime = time;
        }

        public State next() {
            if (this.ordinal() + 1 >= State.values().length) {
                return null;
            }
            return State.values()[this.ordinal() + 1];
        }
    }
}

