/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.block.entity.DeviceBlockEntity;
import dev.ultreon.devices.core.network.Router;
import dev.ultreon.devices.init.DeviceBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RouterBlockEntity
extends DeviceBlockEntity.Colored {
    private Router router;
    private int debugTimer;

    public RouterBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)DeviceBlockEntities.ROUTER.get(), pWorldPosition, pBlockState);
    }

    public Router getRouter() {
        if (this.router == null) {
            this.router = new Router(this.worldPosition);
            this.setChanged();
        }
        return this.router;
    }

    @Override
    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            this.getRouter().tick(this, this.level);
        } else if (this.debugTimer > 0) {
            --this.debugTimer;
        }
    }

    public boolean isDebug() {
        return this.debugTimer > 0;
    }

    public void setDebug(boolean debug) {
        this.debugTimer = debug ? 1200 : 0;
    }

    @Override
    public String getDeviceName() {
        return "Router";
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (tag.contains("router", 10)) {
            this.router = Router.fromTag(this.worldPosition, tag.getCompound("router"));
        }
    }

    public void syncDevicesToClient() {
        this.pipeline.put("router", (Tag)this.getRouter().toTag(true));
        this.sync();
    }
}

