/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.computer;

import dev.ultreon.devices.block.entity.DriveInfo;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.computer.BiosImpl;
import dev.ultreon.devices.core.Bios;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.util.BlockEntityUtil;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ComputerBlockEntity
extends NetworkDeviceBlockEntity.Colored {
    private CompoundTag applicationData = new CompoundTag();
    private CompoundTag systemData = new CompoundTag();
    private FileSystem fileSystem;
    private DyeColor externalDriveColor;

    protected ComputerBlockEntity(BlockEntityType<? extends ComputerBlockEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super(type, pWorldPosition, pBlockState);
    }

    @Override
    public String getDeviceName() {
        return "Laptop";
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains("system_data", 10)) {
            this.systemData = compound.getCompound("system_data");
        }
        if (compound.contains("application_data", 10)) {
            this.applicationData = compound.getCompound("application_data");
        }
        if (compound.contains("file_system")) {
            this.fileSystem = new FileSystem(this, compound.getCompound("file_system"));
        }
        if (compound.contains("external_drive_color", 1)) {
            this.externalDriveColor = null;
            if (compound.getByte("external_drive_color") != -1) {
                this.externalDriveColor = DyeColor.byId((int)compound.getByte("external_drive_color"));
            }
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (this.systemData != null) {
            compound.put("system_data", (Tag)this.systemData);
        }
        if (this.applicationData != null) {
            compound.put("application_data", (Tag)this.applicationData);
        }
        if (this.fileSystem != null) {
            compound.put("file_system", (Tag)this.fileSystem.toTag());
        }
    }

    @Override
    public CompoundTag saveSyncTag() {
        CompoundTag tag = super.saveSyncTag();
        tag.put("system_data", (Tag)this.getSystemData());
        if (this.getFileSystem().getAttachedDrive() != null) {
            tag.putByte("external_drive_color", (byte)this.getFileSystem().getAttachedDriveColor().getId());
        } else {
            tag.putByte("external_drive_color", (byte)-1);
        }
        return tag;
    }

    protected static void doNeighborUpdates(Level level, BlockPos pos, BlockState state) {
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    public CompoundTag getApplicationData() {
        return this.applicationData != null ? this.applicationData : new CompoundTag();
    }

    public CompoundTag getSystemData() {
        if (this.systemData == null) {
            this.systemData = new CompoundTag();
        }
        return this.systemData;
    }

    public void setSystemData(CompoundTag systemData) {
        this.systemData = systemData;
        this.setChanged();
        assert (this.level != null);
        BlockEntityUtil.markBlockForUpdate(this.level, this.worldPosition);
    }

    public FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            this.fileSystem = new FileSystem(this);
        }
        return this.fileSystem;
    }

    public void setApplicationData(String appId, CompoundTag applicationData) {
        this.applicationData = applicationData;
        this.setChanged();
        assert (this.level != null);
        BlockEntityUtil.markBlockForUpdate(this.level, this.worldPosition);
    }

    public boolean isExternalDriveAttached() {
        return this.externalDriveColor != null;
    }

    public DyeColor getExternalDriveColor() {
        return this.externalDriveColor;
    }

    public Map<UUID, DriveInfo> getDriveInfo() {
        return this.getFileSystem().getDrives();
    }

    public Bios getBios() {
        return new BiosImpl(this);
    }

    public boolean isPoweredOn() {
        return true;
    }

    public void powerOff() {
    }
}

