/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.computer;

import dev.ultreon.devices.block.computer.LaptopBlock;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.init.DeviceBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaptopBlockEntity
extends ComputerBlockEntity {
    private static final int OPENED_ANGLE = 102;
    private int attachmentCooldown;
    private int rotation;
    private int prevRotation;
    private boolean open = false;

    public LaptopBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)DeviceBlockEntities.LAPTOP.get()), pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level;
        if (level == null) {
            return;
        }
        if ((Boolean)this.getBlockState().getValue((Property)LaptopBlock.OPEN) != this.open) {
            level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open)), 2);
        }
        if (level.isClientSide) {
            this.prevRotation = this.rotation;
            if (!this.open) {
                if (this.rotation > 0) {
                    this.rotation -= 10;
                }
            } else if (this.rotation < 102) {
                this.rotation += 10;
            }
        }
        if (this.attachmentCooldown > 0) {
            --this.attachmentCooldown;
        }
    }

    public float getScreenAngle(float partialTicks) {
        return -102.0f * (((float)this.prevRotation + (float)(this.rotation - this.prevRotation) * partialTicks) / 102.0f);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains("open")) {
            this.open = compound.getBoolean("open");
            Level level = this.getLevel();
            if (level != null) {
                level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open)), 2);
            }
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putBoolean("open", this.open);
    }

    @Override
    public CompoundTag saveSyncTag() {
        CompoundTag tag = super.saveSyncTag();
        tag.putBoolean("open", this.open);
        return tag;
    }

    @Override
    public boolean isPoweredOn() {
        return this.isOpen();
    }

    @Override
    public void powerOff() {
        super.powerOff();
        if (this.isOpen()) {
            this.openClose(null);
        }
    }

    public void setAttachmentCooldown(int ticks) {
        this.attachmentCooldown = Math.max(ticks, 0);
    }

    public boolean canChangeAttachment() {
        return this.attachmentCooldown <= 0;
    }

    public void openClose(@Nullable Entity entity) {
        Level level = this.level;
        if (level != null) {
            level.gameEvent((Holder)(!this.open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
        }
        boolean oldOpen = this.open;
        boolean bl = this.open = (Boolean)this.getBlockState().getValue((Property)LaptopBlock.OPEN) == false;
        if (oldOpen != this.open) {
            this.pipeline.putBoolean("open", this.open);
            BlockState d = (BlockState)this.getBlockState().setValue((Property)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open));
            this.level.setBlock(this.getBlockPos(), d, 18);
            this.sync();
        }
        if (level != null) {
            this.markUpdated();
            LaptopBlockEntity.doNeighborUpdates(level, this.getBlockPos(), this.getBlockState());
        }
    }

    public boolean isOpen() {
        return this.open;
    }
}

