/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.ultreon.devices.block.ComputerBlock;
import dev.ultreon.devices.block.computer.LaptopBlock;
import dev.ultreon.devices.block.entity.computer.LaptopBlockEntity;
import dev.ultreon.devices.init.DeviceItems;
import dev.ultreon.devices.item.FlashDriveItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class LaptopRenderer
implements BlockEntityRenderer<LaptopBlockEntity> {
    private final Minecraft mc = Minecraft.getInstance();

    public LaptopRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(LaptopBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float direction = ((Direction)blockEntity.getBlockState().getValue((Property)LaptopBlock.FACING)).getClockWise().toYRot();
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        ItemEntity entityItem = new ItemEntity(this, (Level)level, 0.0, 0.0, 0.0, ItemStack.EMPTY){

            public float getSpin(float partialTicks) {
                return ((float)this.getAge() + partialTicks) / 20.0f + 0.0f;
            }
        };
        entityItem.setYRot(0.0f);
        BlockState state = (BlockState)blockEntity.getBlock().defaultBlockState().setValue(LaptopBlock.TYPE, (Comparable)((Object)ComputerBlock.Type.SCREEN));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        poseStack.pushPose();
        if (blockEntity.isExternalDriveAttached()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(((Direction)blockEntity.getBlockState().getValue((Property)LaptopBlock.FACING)).getRotation());
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(-90.0)));
            poseStack.mulPose(new Quaternionf().rotateX((float)Math.toRadians(-90.0)));
            poseStack.translate(-0.5, 0.0, -0.5);
            poseStack.translate(0.595, -0.2075, -0.005);
            entityItem.flyDist = 0.0f;
            FlashDriveItem flashDriveByColor = DeviceItems.getFlashDriveByColor(blockEntity.getExternalDriveColor());
            assert (flashDriveByColor != null);
            entityItem.setItem(new ItemStack((ItemLike)flashDriveByColor, 1));
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(blockEntity.getBlockState().getValue((Property)LaptopBlock.FACING) == Direction.EAST || blockEntity.getBlockState().getValue((Property)LaptopBlock.FACING) == Direction.WEST ? direction + 90.0f : direction - 90.0f));
        poseStack.translate(-0.5, 0.0, -0.5);
        poseStack.translate(0.0, 0.0625, 0.25);
        poseStack.mulPose(Axis.XP.rotationDegrees(blockEntity.getScreenAngle(partialTick) + 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel ibakedmodel = this.mc.getBlockRenderer().getBlockModel(state);
        poseStack.pushPose();
        dispatcher.renderSingleBlock(state, poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.popPose();
        poseStack.popPose();
    }
}

