/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.block.PaperBlock;
import dev.ultreon.devices.block.entity.PaperBlockEntity;
import dev.ultreon.devices.block.entity.renderer.PrinterRenderer;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public record PaperRenderer(BlockEntityRendererProvider.Context context) implements BlockEntityRenderer<PaperBlockEntity>
{
    private static final int TextureIndex = 0;

    private static void drawPixels(PoseStack poseStack, int[] pixels, int resolution, boolean cut, int packedLight, int packedOverlay, MultiBufferSource bufferSource) {
        DynamicTexture d = new DynamicTexture(resolution, resolution, true);
        for (int i = 0; i < resolution; ++i) {
            for (int j = 0; j < resolution; ++j) {
                int r = pixels[j + i * resolution] >> 16 & 0xFF;
                int g = pixels[j + i * resolution] >> 8 & 0xFF;
                int b = pixels[j + i * resolution] & 0xFF;
                int a = (int)((double)(pixels[j + i * resolution] >> 24 & 0xFF));
                assert (d.getPixels() != null);
                d.getPixels().setPixelRGBA(i, j, new Color(r, g, b, a).getRGB());
            }
        }
        ResourceLocation resourcelocation = Minecraft.getInstance().getTextureManager().register("map/0", d);
        Matrix4f matrix4f = poseStack.last().pose();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.text((ResourceLocation)resourcelocation));
        vertexconsumer.addVertex(matrix4f, 0.0f, 1.0f, -0.01f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(packedLight);
        vertexconsumer.addVertex(matrix4f, 1.0f, 1.0f, -0.01f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(packedLight);
        vertexconsumer.addVertex(matrix4f, 1.0f, 0.0f, -0.01f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(packedLight);
        vertexconsumer.addVertex(matrix4f, 0.0f, 0.0f, -0.01f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(packedLight);
    }

    public void render(PaperBlockEntity blockEntity, float partialTick, @NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        CompoundTag data;
        BlockState state = Objects.requireNonNull(blockEntity.getLevel()).getBlockState(blockEntity.getBlockPos());
        if (blockEntity.getBlockState().getBlock() != state.getBlock()) {
            UltreonDevices.LOGGER.error("Paper block mismatch: {} != {}", (Object)blockEntity.getBlockState().getBlock(), (Object)state.getBlock());
            return;
        }
        pose.pushPose();
        pose.translate((float)blockEntity.getBlockPos().getX(), (float)blockEntity.getBlockPos().getY(), (float)blockEntity.getBlockPos().getZ());
        pose.translate(0.5, 0.5, 0.5);
        pose.mulPose(((Direction)state.getValue((Property)PaperBlock.FACING)).getRotation());
        pose.mulPose(new Quaternionf(0.0f, 0.0f, 1.0f, -blockEntity.getRotation()));
        pose.translate(-0.5, -0.5, -0.5);
        IPrint print = blockEntity.getPrint();
        if (print != null && (data = print.toTag()).contains("pixels", 11) && data.contains("resolution", 3)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)PrinterRenderer.PaperModel.TEXTURE);
            if (!((Boolean)DeviceConfig.RENDER_PRINTED_3D.get()).booleanValue() || !data.getBoolean("cut")) {
                // empty if block
            }
            pose.translate(0.0, 0.0, (Boolean)DeviceConfig.RENDER_PRINTED_3D.get() != false ? 0.0625 : 0.001);
            pose.pushPose();
            IPrint.Renderer renderer = PrintingManager.getRenderer(print);
            renderer.render(pose, data);
            pose.popPose();
            pose.pushPose();
            if (((Boolean)DeviceConfig.RENDER_PRINTED_3D.get()).booleanValue() && data.getBoolean("cut")) {
                CompoundTag tag = print.toTag();
                PaperRenderer.drawPixels(pose, tag.getIntArray("pixels"), tag.getInt("resolution"), tag.getBoolean("cut"), packedLight, packedOverlay, bufferSource);
            }
            pose.popPose();
        }
        pose.popPose();
    }
}

