/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.block.PrinterBlock;
import dev.ultreon.devices.block.entity.PrinterBlockEntity;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public record PrinterRenderer(BlockEntityRendererProvider.Context context) implements BlockEntityRenderer<PrinterBlockEntity>
{
    private static final Quaternionf tmpQ = new Quaternionf();
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final double PIXEL_SIZE = 0.015625;

    public void render(PrinterBlockEntity blockEntity, float partialTick, @NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        PaperModel paperModel = new PaperModel(Minecraft.getInstance().getEntityModels().bakeLayer(PaperModel.LAYER_LOCATION));
        BlockState state = Objects.requireNonNull(blockEntity.getLevel()).getBlockState(blockEntity.getBlockPos());
        if (state.getBlock() != blockEntity.getBlock()) {
            return;
        }
        pose.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (blockEntity.hasPaper()) {
            pose.pushPose();
            PrinterRenderer.renderPaper(pose, bufferSource, packedLight, state, paperModel);
            pose.popPose();
        }
        pose.pushPose();
        PrinterRenderer.renderPrint(blockEntity, pose, state, bufferSource, packedLight, packedOverlay, paperModel);
        pose.popPose();
        pose.pushPose();
        PrinterRenderer.renderDisplay(blockEntity, pose, bufferSource, state);
        pose.popPose();
        pose.popPose();
    }

    private static void renderPaper(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, BlockState state, PaperModel paperModel) {
        pose.translate(0.5, 0.5, 0.5);
        pose.mulPose(((Direction)state.getValue((Property)PrinterBlock.FACING)).getRotation());
        pose.mulPose(new Quaternionf().rotateX(1.1780972f));
        pose.translate(0.0, 0.0, 0.4);
        pose.translate(-0.203125, -0.203125, -0.015625);
        pose.scale(0.3f, 0.3f, 0.3f);
        PrinterRenderer.drawBuffer(pose, bufferSource, packedLight, paperModel);
    }

    private static void renderPrint(PrinterBlockEntity blockEntity, @NotNull PoseStack pose, BlockState state, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay, PaperModel paperModel) {
        if (blockEntity.isLoading()) {
            pose.translate(0.5, 0.5, 0.5);
            pose.mulPose(((Direction)state.getValue((Property)PrinterBlock.FACING)).getRotation());
            pose.mulPose(tmpQ.identity().rotateX(1.1780972f));
            double progress = Math.max(-0.4, -0.4 + 0.4 * ((double)(blockEntity.getRemainingPrintTime() - 10) / 20.0));
            pose.translate(0.0, -progress, 0.4);
            pose.translate(-0.203125, -0.203125, -0.015625);
            pose.scale(0.3f, 0.3f, 0.3f);
            PrinterRenderer.drawBuffer(pose, bufferSource, packedLight, paperModel);
        } else if (blockEntity.isPrinting()) {
            pose.translate(0.5, 0.078125, 0.5);
            pose.mulPose(((Direction)state.getValue((Property)PrinterBlock.FACING)).getRotation());
            double progress = -0.35 + (double)(blockEntity.getRemainingPrintTime() - 20) / (double)blockEntity.getTotalPrintTime();
            pose.translate(0.0, -progress, 0.0);
            pose.translate(-0.203125, -0.203125, -0.0078125);
            pose.scale(0.3f, 0.3f, 0.3f);
            PrinterRenderer.drawBuffer(pose, bufferSource, packedLight, paperModel);
            pose.translate(0.4, 0.085, -0.001);
            pose.mulPose(tmpQ.identity().rotateY((float)Math.PI));
            IPrint print = blockEntity.getPrint();
            if (print != null) {
                pose.pushPose();
                pose.translate(-0.9375, 0.46875, 0.0);
                pose.scale(6.1035156E-5f, 6.1035156E-5f, 6.1035156E-5f);
                pose.scale(0.6666667f, 0.6666667f, 0.6666667f);
                IPrint.Renderer renderer = PrintingManager.getRenderer(print);
                VertexConsumer buffer = bufferSource.getBuffer(paperModel.renderType(PaperModel.TEXTURE));
                renderer.render(pose, print.toTag());
                pose.popPose();
            }
        }
    }

    private static void drawBuffer(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, PaperModel paperModel) {
        VertexConsumer buffer = bufferSource.getBuffer(paperModel.renderType(PaperModel.TEXTURE));
        paperModel.renderToBuffer(pose, buffer, packedLight, OverlayTexture.NO_OVERLAY, -1);
    }

    private static void renderDisplay(PrinterBlockEntity blockEntity, @NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, BlockState state) {
        RenderSystem.depthMask((boolean)false);
        pose.translate(0.5, 0.5, 0.5);
        pose.mulPose(((Direction)state.getValue((Property)PrinterBlock.FACING)).getRotation());
        pose.mulPose(tmpQ.identity().rotateY((float)Math.PI));
        pose.translate(0.0675, 0.005, -0.032);
        pose.translate(0.13437500000000002, 0.1875, -0.265625);
        pose.pushPose();
        pose.scale(-0.010416667f, -0.010416667f, -0.010416667f);
        pose.mulPose(tmpQ.identity().rotateX(1.9634954f));
        Font font = Minecraft.getInstance().font;
        String string = Integer.toString(blockEntity.getPaperCount());
        float f = -Minecraft.getInstance().font.width(Integer.toString(blockEntity.getPaperCount()));
        Objects.requireNonNull(Minecraft.getInstance().font);
        font.drawInBatch(string, f, (float)(-9), Color.WHITE.getRGB(), false, pose.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pose.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    public static class PaperModel
    extends Model {
        public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"textures/model/paper.png");
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(UltreonDevices.res("paper_model"), "main");
        private final ModelPart root;
        private final ModelPart main;

        public PaperModel(ModelPart pRoot) {
            super(RenderType::entitySolid);
            this.root = pRoot;
            this.main = pRoot.getChild("main");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 22.0f, 30.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            this.root.render(poseStack, vertexConsumer, i, i1, i2);
        }

        public ModelPart getMain() {
            return this.main;
        }
    }
}

