/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.IIcon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ClientNotification
implements Toast {
    private static final ResourceLocation TEXTURE_TOASTS = ResourceLocation.parse((String)"devices:textures/gui/toast.png");
    private IIcon icon;
    private String title;
    private String subTitle;

    private ClientNotification() {
    }

    @NotNull
    public Toast.Visibility render(@NotNull GuiGraphics graphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_TOASTS);
        graphics.blit(TEXTURE_TOASTS, 0, 0, 0, 0, 160, 32);
        Font font = toastComponent.getMinecraft().font;
        if (this.subTitle == null) {
            graphics.drawString(font, font.plainSubstrByWidth(I18n.get((String)this.title, (Object[])new Object[0]), 118), 38, 12, -1);
        } else {
            graphics.drawString(font, font.plainSubstrByWidth(I18n.get((String)this.title, (Object[])new Object[0]), 118), 38, 7, -1);
            graphics.drawString(font, font.plainSubstrByWidth(I18n.get((String)this.subTitle, (Object[])new Object[0]), 118), 38, 18, -1, false);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.icon.getIconAsset());
        graphics.blit(this.icon.getIconAsset(), 6, 6, this.icon.getGridWidth(), this.icon.getGridHeight(), (float)this.icon.getU(), (float)this.icon.getV(), this.icon.getIconSize(), this.icon.getIconSize(), this.icon.getSourceWidth(), this.icon.getSourceHeight());
        return timeSinceLastVisible >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public static ClientNotification loadFromTag(CompoundTag tag) {
        ClientNotification notification = new ClientNotification();
        int ordinal = tag.getCompound("icon").getInt("ordinal");
        String className = tag.getCompound("icon").getString("className");
        try {
            notification.icon = (IIcon)Class.forName(className).getEnumConstants()[ordinal];
        }
        catch (ClassNotFoundException e) {
            UltreonDevices.LOGGER.error("Failed to load icon for notification", (Throwable)e);
        }
        notification.title = tag.getString("title");
        if (tag.contains("subTitle", 8)) {
            notification.subTitle = tag.getString("subTitle");
        }
        return notification;
    }

    public void push() {
        Minecraft.getInstance().getToasts().addToast((Toast)this);
    }
}

