/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.System;
import dev.ultreon.devices.api.app.SystemAccessor;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.video.CustomResolution;
import dev.ultreon.devices.api.video.VideoInfo;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.Bios;
import dev.ultreon.devices.core.Permission;
import dev.ultreon.devices.core.PermissionManager;
import dev.ultreon.devices.core.PermissionRequest;
import dev.ultreon.devices.core.PermissionResult;
import dev.ultreon.devices.core.PowerMode;
import dev.ultreon.devices.core.Settings;
import dev.ultreon.devices.core.TaskBar;
import dev.ultreon.devices.core.Window;
import dev.ultreon.devices.core.WorldLessBios;
import dev.ultreon.devices.core.Wrappable;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.task.TaskGetMainDrive;
import dev.ultreon.devices.core.task.TaskInstallApp;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.DiagnosticsApp;
import dev.ultreon.devices.programs.system.DisplayResolution;
import dev.ultreon.devices.programs.system.PredefinedResolution;
import dev.ultreon.devices.programs.system.SystemApp;
import dev.ultreon.devices.programs.system.component.FileBrowser;
import dev.ultreon.devices.programs.system.component.FileInfo;
import dev.ultreon.devices.programs.system.task.TaskUpdateApplicationData;
import dev.ultreon.devices.programs.system.task.TaskUpdateSystemData;
import dev.ultreon.devices.util.GLHelper;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComputerScreen
extends Screen
implements System {
    public static final int ID = 1;
    public static final ResourceLocation ICON_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"textures/atlas/app_icons.png");
    public static final int ICON_SIZE = 14;
    private static final ResourceLocation LAPTOP_FONT = UltreonDevices.res("laptop");
    private static Font font;
    private static final ResourceLocation LAPTOP_GUI;
    private static final List<Application> APPLICATIONS;
    private static boolean worldLess;
    private static ComputerScreen instance;
    private Double dragWindowFromX;
    private Double dragWindowFromY;
    private final VideoInfo videoInfo;
    private final Map<UUID, Drive> drives = new HashMap<UUID, Drive>();
    private Dialog systemDialog = null;
    private Window<Dialog> systemDialogWindow = null;
    private static boolean loaded;
    private final Bios bios;
    private static final List<ResourceLocation> WALLPAPERS;
    private static final int BORDER = 10;
    private static final List<Runnable> tasks;
    private static System system;
    private static BlockPos pos;
    private static Drive mainDrive;
    private final Settings settings;
    private final TaskBar bar;
    final CopyOnWriteArrayList<Window<?>> windows;
    private final CompoundTag appData;
    private final CompoundTag systemData;
    protected List<AppInfo> installedApps = new ArrayList<AppInfo>();
    private Layout context = null;
    private Wallpaper currentWallpaper;
    private int lastMouseX;
    private int lastMouseY;
    private boolean dragging = false;
    private final IntArraySet pressed = new IntArraySet();
    private final Image wallpaper;
    private final Layout wallpaperLayout;
    private BSOD bsod;

    public static List<Application> getApplicationsForFabric() {
        return APPLICATIONS;
    }

    public static List<ResourceLocation> getWallpapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    public static Font getFont() {
        if (font == null) {
            font = Minecraft.getInstance().font;
        }
        return font;
    }

    public ComputerScreen(ComputerBlockEntity laptop) {
        this(laptop, false);
    }

    public ComputerScreen(ComputerBlockEntity laptop, boolean worldLess) {
        super((Component)Component.literal((String)"Laptop"));
        instance = this;
        this.bios = this.determineBios(laptop);
        this.appData = laptop.getApplicationData();
        this.systemData = laptop.getSystemData();
        CompoundTag videoInfoData = this.systemData.getCompound("videoInfo");
        this.videoInfo = new VideoInfo(videoInfoData);
        this.windows = new CopyOnWriteArrayList<Window<?>>(){

            @Override
            public Window<?> get(int index) {
                try {
                    return (Window)super.get(index);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean add(Window<?> window) {
                window.removed = false;
                return super.add(window);
            }
        };
        this.settings = Settings.fromTag(this.systemData.getCompound("Settings"));
        CompoundTag taskBarTag = this.systemData.getCompound("TaskBar");
        this.systemData.put("TaskBar", (Tag)taskBarTag);
        this.bar = new TaskBar(this, taskBarTag);
        Wallpaper wallpaper = this.currentWallpaper = this.systemData.contains("CurrentWallpaper", 10) ? new Wallpaper(this.systemData.getCompound("CurrentWallpaper")) : null;
        if (this.currentWallpaper == null) {
            this.currentWallpaper = new Wallpaper(0);
        }
        system = this;
        pos = laptop.getBlockPos();
        this.wallpaperLayout = new Layout(ComputerScreen.getScreenWidth(), ComputerScreen.getScreenHeight());
        this.wallpaper = new Image(0, 0, ComputerScreen.getScreenWidth(), ComputerScreen.getScreenHeight());
        if (this.currentWallpaper.isBuiltIn()) {
            this.wallpaper.setImage(WALLPAPERS.get(this.currentWallpaper.location));
        } else {
            this.wallpaper.setImage(this.currentWallpaper.locationPath);
        }
        this.wallpaperLayout.addComponent(this.wallpaper);
        this.wallpaperLayout.handleLoad();
        ComputerScreen.worldLess = worldLess;
    }

    private Bios determineBios(ComputerBlockEntity laptop) {
        if (laptop == null) {
            return WorldLessBios.INSTANCE;
        }
        return laptop.getBios();
    }

    public static ComputerScreen getInstance() {
        return instance;
    }

    public static int getScreenWidth() {
        return ComputerScreen.instance.videoInfo.getResolution().width();
    }

    public static int getScreenHeight() {
        return ComputerScreen.instance.videoInfo.getResolution().height();
    }

    public static DisplayResolution getResolution() {
        return ComputerScreen.instance.videoInfo.getResolution();
    }

    @Nullable
    public static Drive getDrive(UUID drive) {
        if (drive == null) {
            return null;
        }
        return ComputerScreen.instance.drives.get(drive);
    }

    public CompoundTag getModSystemTag(String modId) {
        CompoundTag mods = this.systemData.getCompound("Mods");
        this.systemData.put("Mods", (Tag)mods);
        CompoundTag mod = mods.getCompound(modId);
        mods.put(modId, (Tag)mod);
        return mod;
    }

    public static boolean isWorldLess() {
        return worldLess;
    }

    @Nullable
    public static BlockPos getPos() {
        return pos;
    }

    public static void addWallpaper(ResourceLocation wallpaper) {
        if (wallpaper != null) {
            WALLPAPERS.add(wallpaper);
        }
    }

    public static System getSystem() {
        return system;
    }

    @Nullable
    public static Drive getMainDrive() {
        return mainDrive;
    }

    public static void getOrLoadMainDrive(Callback<@NotNull Drive> callback) {
        if (mainDrive != null) {
            callback.execute(mainDrive, true);
            return;
        }
        TaskGetMainDrive task = new TaskGetMainDrive(pos);
        task.setCallback((tag, success) -> {
            if (!success) {
                callback.execute(null, false);
                return;
            }
            if (tag != null) {
                mainDrive = new Drive(tag.getCompound("main_drive"));
                callback.execute(mainDrive, true);
                return;
            }
            callback.execute(null, false);
        });
        TaskManager.sendTask(task);
    }

    public static void setMainDrive(Drive mainDrive) {
        if (ComputerScreen.mainDrive == null) {
            ComputerScreen.mainDrive = mainDrive;
        }
    }

    public static void runLater(Runnable task) {
        tasks.add(task);
    }

    public void init() {
        int posX = (this.width - ComputerScreen.getDeviceWidth()) / 2;
        int posY = (this.height - ComputerScreen.getDeviceHeight()) / 2;
        this.bar.init(posX + 10, posY + ComputerScreen.getDeviceHeight() - 28);
        this.installedApps.clear();
        ListTag list = this.systemData.getList("InstalledApps", 8);
        for (int i = 0; i < list.size(); ++i) {
            AppInfo info = ApplicationManager.getApplication(ResourceLocation.tryParse((String)list.getString(i)));
            if (info == null) continue;
            this.installedApps.add(info);
        }
        this.installedApps.sort(AppInfo.SORT_NAME);
        if (Minecraft.getInstance().getConnection() == null) {
            this.installedApps.addAll(ApplicationManager.getAvailableApplications());
        }
    }

    private static int getDeviceWidth() {
        return ComputerScreen.getScreenWidth() + 20;
    }

    private static int getDeviceHeight() {
        return ComputerScreen.getScreenHeight() + 20;
    }

    public void removed() {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null) continue;
            window.close();
            --i;
        }
        this.updateSystemData();
        pos = null;
        system = null;
        mainDrive = null;
    }

    private void updateSystemData() {
        this.systemData.put("CurrentWallpaper", this.currentWallpaper.serialize());
        this.systemData.put("Settings", (Tag)this.settings.toTag());
        this.systemData.put("TaskBar", (Tag)this.bar.serialize());
        ListTag tagListApps = new ListTag();
        this.installedApps.forEach(info -> tagListApps.add((Object)StringTag.valueOf((String)info.getFormattedId())));
        this.systemData.put("InstalledApps", (Tag)tagListApps);
        TaskManager.sendTask(new TaskUpdateSystemData(pos, this.systemData));
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (this.videoInfo.getResolution().width() > width || this.videoInfo.getResolution().height() > height) {
            this.videoInfo.setResolution(new CustomResolution(width, height));
        }
        this.revalidateDisplay();
    }

    public void revalidateDisplay() {
        this.wallpaper.componentWidth = this.videoInfo.getResolution().width();
        this.wallpaper.componentHeight = this.videoInfo.getResolution().height();
        this.wallpaperLayout.width = this.videoInfo.getResolution().width();
        this.wallpaperLayout.height = this.videoInfo.getResolution().height();
        this.wallpaperLayout.updateComponents(0, 0);
        for (Window<?> window : this.windows) {
            if (window == null) continue;
            ((Wrappable)window.content).markForLayoutUpdate();
        }
    }

    public void tick() {
        try {
            this.bar.onTick();
            for (Window<?> window : List.copyOf(this.windows)) {
                window.onTick();
                if (!window.removed) continue;
                this.windows.remove(window);
            }
            FileBrowser.refreshList = false;
        }
        catch (Exception e) {
            this.bsod(e);
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.bsod != null) {
            this.renderBsod(graphics, mouseX, mouseY, partialTicks);
            return;
        }
        RenderSystem.disableDepthTest();
        PoseStack.Pose last = graphics.pose().last();
        try {
            this.renderLaptop(graphics, mouseX, mouseY, partialTicks);
        }
        catch (NullPointerException e) {
            while (graphics.pose().last() != last) {
                graphics.pose().popPose();
            }
            RenderSystem.disableScissor();
            this.bsod(e);
        }
        catch (Exception e) {
            while (graphics.pose().last() != last) {
                graphics.pose().popPose();
            }
            RenderSystem.disableScissor();
            this.bsod(e);
        }
    }

    public void renderBsod(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBezels(graphics, mouseX, mouseY, partialTicks);
        int posX = (this.width - ComputerScreen.getDeviceWidth()) / 2;
        int posY = (this.height - ComputerScreen.getDeviceHeight()) / 2;
        graphics.fill(posX + 10, posY + 10, posX + ComputerScreen.getDeviceWidth() - 10, posY + ComputerScreen.getDeviceHeight() - 10, new Color(0, 0, 255).getRGB());
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        double scale = Minecraft.getInstance().getWindow().getGuiScale();
        PrintStream b = new PrintStream(bo);
        this.bsod.throwable.printStackTrace(b);
        String str = bo.toString();
        Font font = ComputerScreen.getFont();
        Objects.requireNonNull(ComputerScreen.getFont());
        ComputerScreen.drawLines(graphics, font, str, posX + 10, posY + 10 + 9 * 2, (int)((double)(ComputerScreen.getDeviceWidth() - 10) * scale), new Color(255, 255, 255).getRGB());
        graphics.pose().pushPose();
        graphics.pose().scale(2.0f, 2.0f, 0.0f);
        graphics.pose().translate((float)(posX + 10) / 2.0f, (float)(posY + 10) / 2.0f, 0.0f);
        graphics.drawString(ComputerScreen.getFont(), "System has crashed!", 0, 0, new Color(255, 255, 255).getRGB());
        graphics.pose().popPose();
    }

    public static void drawLines(GuiGraphics graphics, Font font, String text, int x, int y, int width, int color) {
        ArrayList lines = new ArrayList();
        font.getSplitter().splitLines(FormattedText.of((String)text.replaceAll("\r\n", "\n").replaceAll("\r", "\n")), width, Style.EMPTY).forEach(b -> lines.add(b.getString()));
        Objects.requireNonNull(font);
        int totalTextHeight = 9 * lines.size();
        int n = ComputerScreen.instance.videoInfo.getResolution().height() - 20;
        Objects.requireNonNull(ComputerScreen.getFont());
        float textScale = (float)(n - 9 * 2) / (float)totalTextHeight;
        textScale = (float)(1.0 / Minecraft.getInstance().getWindow().getGuiScale());
        textScale = Math.max(0.5f, textScale);
        graphics.pose().pushPose();
        graphics.pose().scale(textScale, textScale, 1.0f);
        graphics.pose().translate((float)x / textScale, (float)(y + 3) / textScale, 0.0f);
        int lineNr = 0;
        for (String s : lines) {
            String string = s.replaceAll("\t", "    ");
            Objects.requireNonNull(font);
            graphics.drawString(font, string, 0, lineNr * 9, color);
            ++lineNr;
        }
        graphics.pose().popPose();
    }

    public void renderBezels(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        tasks.clear();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LAPTOP_GUI);
        int deviceWidth = this.videoInfo.getResolution().width() + 20;
        int deviceHeight = this.videoInfo.getResolution().height() + 20;
        int posX = (this.width - deviceWidth) / 2;
        int posY = (this.height - deviceHeight) / 2;
        graphics.blit(LAPTOP_GUI, posX, posY, 0, 0, 10, 10);
        graphics.blit(LAPTOP_GUI, posX + deviceWidth - 10, posY, 11, 0, 10, 10);
        graphics.blit(LAPTOP_GUI, posX + deviceWidth - 10, posY + deviceHeight - 10, 11, 11, 10, 10);
        graphics.blit(LAPTOP_GUI, posX, posY + deviceHeight - 10, 0, 11, 10, 10);
        graphics.blit(LAPTOP_GUI, posX + 10, posY, ComputerScreen.getScreenWidth(), 10, 10.0f, 0.0f, 1, 10, 256, 256);
        graphics.blit(LAPTOP_GUI, posX + deviceWidth - 10, posY + 10, 10, ComputerScreen.getScreenHeight(), 11.0f, 10.0f, 10, 1, 256, 256);
        graphics.blit(LAPTOP_GUI, posX + 10, posY + deviceHeight - 10, ComputerScreen.getScreenWidth(), 10, 10.0f, 11.0f, 1, 10, 256, 256);
        graphics.blit(LAPTOP_GUI, posX, posY + 10, 10, ComputerScreen.getScreenHeight(), 0.0f, 11.0f, 10, 1, 256, 256);
        graphics.blit(LAPTOP_GUI, posX + 10, posY + 10, ComputerScreen.getScreenWidth(), ComputerScreen.getScreenHeight(), 10.0f, 10.0f, 1, 1, 256, 256);
    }

    public void renderLaptop(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int posX = (this.width - ComputerScreen.getDeviceWidth()) / 2;
        int posY = (this.height - ComputerScreen.getDeviceHeight()) / 2;
        float frameTime = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        for (Runnable task : tasks) {
            task.run();
        }
        this.renderBezels(graphics, mouseX, mouseY, partialTicks);
        GLHelper.pushScissor(posX, posY, this.videoInfo.getResolution().width() + 10, this.videoInfo.getResolution().height() + 10);
        Image.CACHE.forEach((s, cachedImage) -> cachedImage.delete());
        this.wallpaperLayout.render(graphics, this, this.minecraft, posX + 10, posY + 10, mouseX, mouseY, true, partialTicks);
        boolean insideContext = false;
        if (this.context != null) {
            insideContext = this.isMouseInside(mouseX, mouseY, this.context.xPosition, this.context.yPosition, this.context.xPosition + this.context.width, this.context.yPosition + this.context.height);
        }
        graphics.pose().pushPose();
        this.renderWindows(graphics, mouseX, mouseY, partialTicks, posX, posY, insideContext);
        this.bar.render(graphics, this, this.minecraft, posX + 10, posY + ComputerScreen.getDeviceHeight() - 28, mouseX, mouseY, frameTime);
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (this.context != null) {
            this.context.render(graphics, this, this.minecraft, this.context.xPosition, this.context.yPosition, mouseX, mouseY, true, frameTime);
        }
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        if (this.systemDialogWindow != null && this.systemDialogWindow.removed) {
            this.systemDialog = null;
            this.systemDialogWindow = null;
        }
        if (this.systemDialogWindow != null) {
            graphics.fill(posX + 10, posY + 10, posX + ComputerScreen.getDeviceWidth() - 10, posY + ComputerScreen.getDeviceHeight() - 10, 0x60000000);
            int w = ComputerScreen.getScreenWidth() / 2 - this.systemDialog.getWidth() / 2;
            int h = ComputerScreen.getScreenHeight() / 2 - this.systemDialog.getHeight() / 2;
            this.systemDialogWindow.render(graphics, this, this.minecraft, posX + 10, posY + 10, mouseX, mouseY, true, partialTicks);
        }
        graphics.pose().popPose();
        Image.CACHE.entrySet().removeIf(entry -> {
            Image.CachedImage cachedImage = (Image.CachedImage)entry.getValue();
            if (cachedImage.isDynamic() && cachedImage.isPendingDeletion()) {
                int texture = cachedImage.getTextureId();
                if (texture != -1) {
                    RenderSystem.deleteTexture((int)texture);
                }
                return true;
            }
            return false;
        });
        GLHelper.popScissor();
        GLHelper.clearScissorStack();
    }

    private void renderWindows(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, int posX, int posY, boolean insideContext) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window<?> window = this.windows.get(i);
            if (window == null) continue;
            this.renderWindow(graphics, mouseX, mouseY, partialTicks, posX, posY, insideContext, i, window);
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
        }
    }

    private void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, int posX, int posY, boolean insideContext, int i, Window<?> window) {
        block7: {
            PoseStack.Pose last = graphics.pose().last();
            try {
                if (i == 0 && this.systemDialogWindow == null) {
                    window.render(graphics, this, this.minecraft, posX + 10, posY + 10, mouseX, mouseY, !insideContext && this.systemDialogWindow == null, partialTicks);
                } else {
                    window.render(graphics, this, this.minecraft, posX + 10, posY + 10, Integer.MAX_VALUE, Integer.MAX_VALUE, false, partialTicks);
                }
                if (i == 0 && this.systemDialogWindow == null) {
                    window.renderOverlay(graphics, this, this.minecraft, posX + 10, posY + 10, mouseX, mouseY, !insideContext && this.systemDialogWindow == null, partialTicks);
                } else {
                    window.renderOverlay(graphics, this, this.minecraft, posX + 10, posY + 10, Integer.MAX_VALUE, Integer.MAX_VALUE, false, partialTicks);
                }
            }
            catch (Exception e) {
                while (graphics.pose().last() != last) {
                    graphics.pose().popPose();
                }
                RenderSystem.disableScissor();
                UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
                Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                message.setTitle("Error");
                CompoundTag intent = new CompoundTag();
                Object t = window.content;
                if (!(t instanceof Application)) break block7;
                Application app = (Application)t;
                this.openDiagnostics(app, intent);
            }
        }
    }

    private void openDiagnostics(Application app, CompoundTag intent) {
        AppInfo info = app.getInfo();
        if (info != null) {
            String name = info.getName();
            if (name == null) {
                name = info.getId().toString();
            }
            intent.putString("name", name);
        }
        this.launchApp(ApplicationManager.getApplication(UltreonDevices.res("diagnostics")), intent);
        this.closeApplication(app);
    }

    private boolean isMouseInside(int mouseX, int mouseY, int startX, int startY, int endX, int endY) {
        return mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            return this.mouseClickedInternal(mouseX, mouseY, mouseButton);
        }
        catch (NullPointerException e) {
            this.bsod(e);
        }
        catch (Exception e) {
            this.bsod(e);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void bsod(Throwable e) {
        this.bsod = new BSOD(e);
        UltreonDevices.LOGGER.error("A fatal error has occurred.", e);
    }

    public VideoInfo getVideoInfo() {
        return this.videoInfo;
    }

    public void setDisplayResolution(PredefinedResolution newValue) {
        if (this.videoInfo != null) {
            this.videoInfo.setResolution(newValue);
        }
    }

    public void requestPermission(PermissionRequest permissionRequest, Consumer<PermissionResult> callback) {
        String reason;
        Permission permission = permissionRequest.permission();
        if (permission == null) {
            callback.accept(PermissionResult.DENIED);
        }
        if ((reason = permissionRequest.reason()) == null) {
            reason = "App did not specify a reason.";
        }
        this.setSystemDialog(new Dialog.Permission(permissionRequest, result -> PermissionManager.grant(permission, () -> callback.accept((PermissionResult)result)), reason));
    }

    public boolean mouseClickedInternal(double mouseX, double mouseY, int mouseButton) {
        if (this.bsod != null) {
            return true;
        }
        if (this.systemDialogWindow != null) {
            int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
            int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
            this.systemDialogWindow.handleMouseClick(this, posX, posY, (int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        this.lastMouseX = (int)mouseX;
        this.lastMouseY = (int)mouseY;
        int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
        int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
        if (this.context != null) {
            int dropdownX = this.context.xPosition;
            int dropdownY = this.context.yPosition;
            if (this.isMouseInside((int)mouseX, (int)mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                this.context.handleMouseClick((int)mouseX, (int)mouseY, mouseButton);
                return true;
            }
            this.context = null;
        }
        this.bar.handleClick(this, posX, posY + ComputerScreen.getScreenHeight() - 18, (int)mouseX, (int)mouseY, mouseButton);
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null) continue;
            try {
                Window<Dialog> dialogWindow = ((Application)window.getContent()).getActiveDialog();
                if (!this.isMouseWithinWindow((int)mouseX, (int)mouseY, window) && !this.isMouseWithinWindow((int)mouseX, (int)mouseY, dialogWindow)) continue;
                this.windows.remove(i);
                --i;
                this.updateWindowStack();
                this.windows.addFirst(window);
                this.windows.getFirst().handleMouseClick(this, posX, posY, (int)mouseX, (int)mouseY, mouseButton);
                if (this.isMouseWithinWindowBar((int)mouseX, (int)mouseY, dialogWindow)) {
                    this.dragWindowFromX = mouseX - (double)dialogWindow.offsetX;
                    this.dragWindowFromY = mouseY - (double)dialogWindow.offsetY;
                    this.dragging = true;
                    return false;
                }
                if (!this.isMouseWithinWindowBar((int)mouseX, (int)mouseY, window) || dialogWindow != null) break;
                this.dragWindowFromX = mouseX - (double)window.offsetX;
                this.dragWindowFromY = mouseY - (double)window.offsetY;
                this.dragging = true;
                return false;
            }
            catch (Exception e) {
                UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
                Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                message.setTitle("Error");
                if (this.windows.isEmpty() || this.windows.getFirst() == null) {
                    CompoundTag intent = new CompoundTag();
                    AppInfo info = ((Application)window.content).getInfo();
                    if (info != null) {
                        intent.putString("name", info.getName());
                    }
                    this.launchApp(ApplicationManager.getApplication(UltreonDevices.res("diagnostics")), intent);
                    continue;
                }
                this.setSystemDialog(message);
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void setSystemDialog(Dialog message) {
        this.systemDialog = message;
        this.systemDialogWindow = new Window<Dialog>(this.systemDialog, null);
        this.systemDialogWindow.init(this.width / 2 - this.systemDialog.getWidth() / 2, this.height / 2 - this.systemDialog.getHeight() / 2, null);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (this.bsod != null) {
            return true;
        }
        if (this.systemDialogWindow != null) {
            this.systemDialogWindow.handleMouseRelease((int)mouseX, (int)mouseY, state);
            return true;
        }
        super.mouseReleased(mouseX, mouseY, state);
        this.dragging = false;
        this.dragWindowFromX = null;
        this.dragWindowFromY = null;
        try {
            if (this.context != null) {
                int dropdownX = this.context.xPosition;
                int dropdownY = this.context.yPosition;
                if (this.isMouseInside((int)mouseX, (int)mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                    this.context.handleMouseRelease((int)mouseX, (int)mouseY, state);
                }
            } else if (!this.windows.isEmpty()) {
                this.windows.getFirst().handleMouseRelease((int)mouseX, (int)mouseY, state);
            }
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.setSystemDialog(message);
        }
        return true;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.bsod != null) {
            return false;
        }
        if (this.systemDialogWindow != null) {
            this.systemDialogWindow.handleCharTyped(codePoint, modifiers);
            return true;
        }
        boolean override = super.charTyped(codePoint, modifiers);
        try {
            if (!override && !this.windows.isEmpty()) {
                this.windows.getFirst().handleCharTyped(codePoint, modifiers);
            }
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.setSystemDialog(message);
        }
        return override;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.bsod != null) {
            this.bios.systemExit(PowerMode.REBOOT);
            return true;
        }
        if (this.systemDialogWindow != null) {
            this.systemDialogWindow.handleKeyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        boolean override = super.keyPressed(keyCode, scanCode, modifiers);
        try {
            if (!(this.pressed.contains(keyCode) || override || this.windows.isEmpty())) {
                this.windows.getFirst().handleKeyPressed(keyCode, scanCode, modifiers);
            }
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.setSystemDialog(message);
            return true;
        }
        this.pressed.add(keyCode);
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.pressed.remove(keyCode);
        boolean b = super.keyReleased(keyCode, scanCode, modifiers);
        try {
            if (keyCode >= 32 && keyCode < 256 && !this.windows.isEmpty()) {
                this.windows.getFirst().handleKeyReleased(keyCode, scanCode, modifiers);
                return true;
            }
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.setSystemDialog(message);
        }
        return b;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.bsod != null) {
            return true;
        }
        if (this.systemDialogWindow != null) {
            this.systemDialogWindow.handleMouseDrag((int)mouseX, (int)mouseY, button);
            return true;
        }
        int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
        int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
        try {
            if (this.context != null) {
                int dropdownX = this.context.xPosition;
                int dropdownY = this.context.yPosition;
                if (this.isMouseInside((int)mouseX, (int)mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                    this.context.handleMouseDrag((int)mouseX, (int)mouseY, button);
                }
                return true;
            }
            if (!this.windows.isEmpty()) {
                Window<?> window = this.windows.getFirst();
                Window<Dialog> dialogWindow = ((Application)window.getContent()).getActiveDialog();
                if (this.dragging) {
                    if (this.isMouseOnScreen((int)mouseX, (int)mouseY) && this.dragWindowFromX != null && this.dragWindowFromY != null) {
                        Objects.requireNonNullElse(dialogWindow, window).handleWindowMove(posX, posY, (int)(dragX + mouseX - this.dragWindowFromX), (int)(dragY + mouseY - this.dragWindowFromY));
                    } else {
                        this.dragging = false;
                    }
                } else if (this.isMouseWithinWindow((int)mouseX, (int)mouseY, window) || this.isMouseWithinWindow((int)mouseX, (int)mouseY, dialogWindow)) {
                    window.handleMouseDrag((int)mouseX, (int)mouseY, button);
                }
            }
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.setSystemDialog(message);
        }
        this.lastMouseX = (int)mouseX;
        this.lastMouseY = (int)mouseY;
        return true;
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        this.lastMouseX = (int)pMouseX;
        this.lastMouseY = (int)pMouseY;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.bsod != null) {
            return true;
        }
        if (this.systemDialogWindow != null) {
            this.systemDialogWindow.handleMouseScroll((int)mouseX, (int)mouseY, deltaY, deltaY >= 0.0);
            return true;
        }
        if (deltaY != 0.0) {
            try {
                if (!this.windows.isEmpty()) {
                    this.windows.getFirst().handleMouseScroll((int)mouseX, (int)mouseY, deltaY, deltaY >= 0.0);
                }
            }
            catch (Exception e) {
                UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
                Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                message.setTitle("Error");
                this.setSystemDialog(message);
            }
        }
        return true;
    }

    public void renderComponentTooltip(@NotNull GuiGraphics graphics, @NotNull List<Component> tooltips, int x, int y) {
        if (this.minecraft != null) {
            graphics.renderComponentTooltip(this.minecraft.font, tooltips, x, y);
        }
    }

    public Pair<Application, Boolean> sendApplicationToFront(AppInfo info) {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null || !(window.content instanceof Application) || ((Application)window.content).getInfo() != info) continue;
            this.windows.remove(i);
            this.updateWindowStack();
            this.windows.addFirst(window);
            return Pair.of((Object)((Application)window.content), (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    @Override
    public Application launchApp(AppInfo info) {
        return this.launchApp(info, null);
    }

    @Override
    public Application launchApp(AppInfo info, CompoundTag intentTag) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        Application[] a = new Application[]{null};
        optional.ifPresent(application -> {
            a[0] = this.launchApp((Application)application, intentTag);
        });
        return a[0];
    }

    @Override
    @Nullable
    public Application loadApp(AppInfo info) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        return optional.orElse(null);
    }

    private Application launchApp(Application app, CompoundTag intent) {
        if (!(app instanceof DiagnosticsApp)) {
            if (this.isApplicationNotInstalled(app.getInfo())) {
                return null;
            }
            if (this.isInvalidApplication(app.getInfo())) {
                return null;
            }
        }
        try {
            Pair<Application, Boolean> q = this.sendApplicationToFront(app.getInfo());
            if (((Boolean)q.right()).booleanValue()) {
                return (Application)q.left();
            }
            if (app instanceof SystemApp) {
                ((SystemApp)app).setLaptop(this);
            }
            if (app instanceof SystemAccessor) {
                ((SystemAccessor)((Object)app)).sendSystem(this);
            }
            Window<Application> window = new Window<Application>(app, this);
            window.init((this.width - ComputerScreen.getScreenWidth()) / 2, (this.height - ComputerScreen.getScreenHeight()) / 2, intent);
            if (this.appData.contains(app.getInfo().getFormattedId())) {
                app.load(this.appData.getCompound(app.getInfo().getFormattedId()));
            }
            if (app.getCurrentLayout() == null) {
                app.restoreDefaultLayout();
            }
            this.addWindow(window);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            AppInfo info = ApplicationManager.getApplication(UltreonDevices.res("diagnostics"));
            system.launchApp(info);
        }
        return app;
    }

    public void launchApp(AppInfo info, FileInfo file, Callback<Application> callback) {
        if (this.isApplicationNotInstalled(info)) {
            if (callback != null) {
                callback.execute(null, false);
            }
            return;
        }
        if (this.isInvalidApplication(info)) {
            if (callback != null) {
                callback.execute(null, false);
            }
            return;
        }
        try {
            Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
            if (optional.isPresent()) {
                Application application = optional.get();
                boolean alreadyRunning = this.isApplicationRunning(info);
                this.launchApp(application, null);
                if (this.isApplicationRunning(info) && !application.handleFile(file, (response, success) -> {
                    if (success) {
                        if (!alreadyRunning) {
                            this.closeApplication(application);
                        }
                        callback.execute(application, true);
                    } else {
                        callback.execute(application, false);
                    }
                })) {
                    system.openDialog(new Dialog.Message("The file could not be opened."));
                }
            }
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
            AppInfo info1 = ApplicationManager.getApplication(UltreonDevices.res("diagnostics"));
            system.launchApp(info1);
        }
    }

    @Override
    public void closeApplication(AppInfo info) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        optional.ifPresent(this::closeApplication);
    }

    private void closeApplication(Application app) {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null || !((Application)window.content).getInfo().equals(app.getInfo())) continue;
            if (app.isDirty()) {
                CompoundTag container = new CompoundTag();
                app.save(container);
                app.clean();
                this.appData.put(app.getInfo().getFormattedId(), (Tag)container);
                TaskManager.sendTask(new TaskUpdateApplicationData(pos.getX(), pos.getY(), pos.getZ(), app.getInfo().getFormattedId(), container));
            }
            if (app instanceof SystemApp) {
                ((SystemApp)app).setLaptop(null);
            }
            window.handleClose();
            this.windows.remove(i);
            return;
        }
    }

    private void addWindow(Window<Application> window) {
        if (this.hasReachedWindowLimit()) {
            return;
        }
        this.updateWindowStack();
        this.windows.addFirst(window);
    }

    private void updateWindowStack() {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            if (this.windows.get(i) == null || i + 1 >= this.windows.size() || i != 0 && this.windows.get(i - 1) == null || this.windows.get(i + 1) != null) continue;
            this.windows.add(i + 1, this.windows.get(i));
            this.windows.remove(i);
        }
    }

    private boolean hasReachedWindowLimit() {
        return this.windows.size() >= 1024;
    }

    private boolean isMouseOnScreen(int mouseX, int mouseY) {
        int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
        int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
        return this.isMouseInside(mouseX, mouseY, posX, posY, posX + ComputerScreen.getScreenWidth(), posY + ComputerScreen.getScreenHeight());
    }

    private boolean isMouseWithinWindowBar(int mouseX, int mouseY, Window<?> window) {
        if (window == null) {
            return false;
        }
        int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
        int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
        return this.isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 1, posX + window.offsetX + window.width - 13, posY + window.offsetY + 11);
    }

    private boolean isMouseWithinWindow(int mouseX, int mouseY, Window<?> window) {
        if (window == null) {
            return false;
        }
        int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
        int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
        return this.isMouseInside(mouseX, mouseY, posX + window.offsetX, posY + window.offsetY, posX + window.offsetX + window.width, posY + window.offsetY + window.height);
    }

    public boolean isMouseWithinApp(int mouseX, int mouseY, Window<?> window) {
        int posX = (this.width - ComputerScreen.getScreenWidth()) / 2;
        int posY = (this.height - ComputerScreen.getScreenHeight()) / 2;
        return this.isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 13, posX + window.offsetX + window.width - 1, posY + window.offsetY + window.height - 1);
    }

    public boolean isApplicationRunning(AppInfo info) {
        for (Window<?> window : this.windows) {
            if (window == null || ((Application)window.content).getInfo() != info) continue;
            return true;
        }
        return false;
    }

    public void nextWallpaper() {
        if (!this.currentWallpaper.isBuiltIn()) {
            return;
        }
        if (this.currentWallpaper.location + 1 < WALLPAPERS.size()) {
            this.currentWallpaper = new Wallpaper(this.currentWallpaper.location + 1);
        }
        this.wallpaperUpdated();
    }

    public void prevWallpaper() {
        if (this.currentWallpaper.location - 1 >= 0) {
            this.currentWallpaper = new Wallpaper(this.currentWallpaper.location - 1);
        }
        this.wallpaperUpdated();
    }

    private void wallpaperUpdated() {
        if (this.currentWallpaper.isBuiltIn()) {
            this.wallpaper.setImage(WALLPAPERS.get(this.currentWallpaper.location));
        } else {
            this.wallpaper.setImage(this.currentWallpaper.locationPath);
        }
    }

    public void setWallpaper(Path path) {
        this.currentWallpaper = new Wallpaper(path);
        this.wallpaperUpdated();
    }

    public void setWallpaper(int wall) {
        this.currentWallpaper = new Wallpaper(wall);
        this.wallpaperUpdated();
    }

    public Wallpaper getCurrentWallpaper() {
        return this.currentWallpaper;
    }

    public List<ResourceLocation> getWallapapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    @Nullable
    public Application getApplication(String appId) {
        return APPLICATIONS.stream().filter(app -> app.getInfo().getFormattedId().equals(appId)).findFirst().orElse(null);
    }

    public List<AppInfo> getInstalledApplications() {
        return ImmutableList.copyOf(this.installedApps);
    }

    @Override
    public void openDialog(Dialog message) {
        this.systemDialog = message;
    }

    public boolean isApplicationInstalled(AppInfo info) {
        return info.isSystemApp() || this.installedApps.contains(info);
    }

    public boolean isApplicationNotInstalled(AppInfo info) {
        return !this.isApplicationInstalled(info);
    }

    private boolean isValidApplication(AppInfo info) {
        if (UltreonDevices.hasAllowedApplications()) {
            return UltreonDevices.getAllowedApplications().contains(info);
        }
        return true;
    }

    private boolean isInvalidApplication(AppInfo info) {
        return !this.isValidApplication(info);
    }

    public void installApplication(AppInfo info, @Nullable Callback<Object> callback) throws AccessDeniedException {
        if (!PermissionManager.hasPermission(Permission.SOFTWARE_MANAGEMENT)) {
            throw new AccessDeniedException("You do not have permission to install applications");
        }
        if (this.isValidApplication(info)) {
            TaskInstallApp task = new TaskInstallApp(info, pos, true);
            task.setCallback((tag, success) -> {
                if (success) {
                    this.installedApps.add(info);
                    this.installedApps.sort(AppInfo.SORT_NAME);
                }
                if (callback != null) {
                    callback.execute(null, success);
                }
            });
            TaskManager.sendTask(task);
        }
    }

    public void removeApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (!this.isValidApplication(info)) {
            return;
        }
        TaskInstallApp task = new TaskInstallApp(info, pos, false);
        task.setCallback((tag, success) -> {
            if (success) {
                this.installedApps.remove(info);
            }
            if (callback != null) {
                callback.execute(null, success);
            }
        });
        TaskManager.sendTask(task);
    }

    public static void loadApplications(Consumer<List<Application>> loader) {
        if (loaded) {
            throw new IllegalStateException("Applications are already loaded");
        }
        loaded = true;
        loader.accept(APPLICATIONS);
    }

    public TaskBar getTaskBar() {
        return this.bar;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void openContext(Layout layout, int x, int y) {
        layout.updateComponents(x, y);
        this.context = layout;
        layout.init();
    }

    @Override
    public boolean hasContext() {
        return this.context != null;
    }

    @Override
    public void closeContext() {
        this.context = null;
        this.dragging = false;
    }

    static {
        LAPTOP_GUI = ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"textures/gui/laptop.png");
        APPLICATIONS = new ArrayList<Application>();
        WALLPAPERS = new ArrayList<ResourceLocation>();
        tasks = new CopyOnWriteArrayList<Runnable>();
    }

    public static final class Wallpaper {
        private final Path locationPath;
        private final int location;

        public Wallpaper(Path of) {
            this.locationPath = of;
            this.location = -87;
        }

        public Path getPath() {
            return this.locationPath;
        }

        public int getLocation() {
            return this.location;
        }

        private Wallpaper(CompoundTag tag) {
            String url = tag.getString("url");
            int location = tag.getInt("location");
            if (tag.contains("path", 8)) {
                this.locationPath = Path.of(tag.getString("path"));
                this.location = -87;
            } else {
                this.locationPath = Path.of(url);
                this.location = location;
            }
        }

        private Wallpaper(int location) {
            this.location = location;
            this.locationPath = null;
        }

        public boolean isBuiltIn() {
            return this.location != -87;
        }

        public Tag serialize() {
            CompoundTag a = new CompoundTag();
            if (this.isBuiltIn()) {
                a.putInt("location", this.location);
            } else {
                a.putString("path", this.locationPath.toString());
            }
            return a;
        }
    }

    private static final class BSOD {
        private final Throwable throwable;

        public BSOD(Throwable e) {
            this.throwable = e;
        }
    }
}

