/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import dev.ultreon.devices.block.entity.DeviceBlockEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Device {
    protected UUID id;
    protected String name;
    protected BlockPos pos;

    protected Device() {
    }

    public Device(@NotNull DeviceBlockEntity device) {
        this.id = device.getId();
        this.update(device);
    }

    public Device(@NotNull UUID id, @NotNull String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(@Nullable BlockPos pos) {
        this.pos = pos;
    }

    public void update(@NotNull DeviceBlockEntity device) {
        this.name = device.getCustomName();
        this.pos = device.getBlockPos();
    }

    @Nullable
    public DeviceBlockEntity getDevice(@NotNull Level level) {
        DeviceBlockEntity deviceBlockEntity;
        if (this.pos == null) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof DeviceBlockEntity && (deviceBlockEntity = (DeviceBlockEntity)blockEntity).getId().equals(this.getId())) {
            return deviceBlockEntity;
        }
        return null;
    }

    public CompoundTag toTag(boolean includePos) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", this.getId().toString());
        tag.putString("name", this.getName());
        if (includePos) {
            tag.putLong("pos", this.pos.asLong());
        }
        return tag;
    }

    public static Device fromTag(CompoundTag tag) {
        Device device = new Device();
        device.id = UUID.fromString(tag.getString("id"));
        device.name = tag.getString("name");
        if (tag.contains("pos", 4)) {
            device.pos = BlockPos.of((long)tag.getLong("pos"));
        }
        return device;
    }
}

