/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.core.io.drive.ExternalDrive;
import dev.ultreon.devices.core.io.drive.InternalDrive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.ApiStatus;

public class DriveManager {
    private static final Map<UUID, ExternalDrive> EXTERNAL_DRIVES = new ConcurrentHashMap<UUID, ExternalDrive>();
    private static final Map<UUID, InternalDrive> INTERNAL_DRIVES = new ConcurrentHashMap<UUID, InternalDrive>();
    private static final Map<UUID, Long> LAST_ACCESS_TIMES = new ConcurrentHashMap<UUID, Long>();

    public static InternalDrive getInternalDrive(UUID uuid) {
        return INTERNAL_DRIVES.computeIfAbsent(uuid, id -> InternalDrive.load(id, AbstractDrive.getDrivePath(id)));
    }

    public static ExternalDrive getExternalDrive(UUID uuid) {
        return EXTERNAL_DRIVES.computeIfAbsent(uuid, id -> ExternalDrive.load(id, AbstractDrive.getDrivePath(id)));
    }

    public static void registerExternalDrive(ExternalDrive externalDrive) {
        EXTERNAL_DRIVES.put(externalDrive.getUuid(), externalDrive);
    }

    public static void registerInternalDrive(InternalDrive internalDrive) {
        INTERNAL_DRIVES.put(internalDrive.getUuid(), internalDrive);
    }

    public static void removeDrive(UUID uuid) {
        INTERNAL_DRIVES.remove(uuid);
        EXTERNAL_DRIVES.remove(uuid);
        AbstractDrive.deleteDrivePath(uuid);
    }

    @ApiStatus.Internal
    public static void loadDriveMeta() {
        Path resolve = UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drive_meta.dat");
        if (Files.exists(resolve, new LinkOption[0])) {
            CompoundTag driveMeta = null;
            try {
                driveMeta = NbtIo.readCompressed((Path)resolve, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException e) {
                UltreonDevices.LOGGER.error("Failed to load drive meta!", (Throwable)e);
            }
            if (driveMeta != null) {
                CompoundTag driveMetaInternal = driveMeta.getCompound("Internal");
                for (String key : driveMetaInternal.getAllKeys()) {
                    long lastAccessed = driveMetaInternal.getLong(key);
                    if (lastAccessed <= 0L) continue;
                    UUID uuid = UUID.fromString(key);
                    LAST_ACCESS_TIMES.put(uuid, lastAccessed);
                }
                CompoundTag driveMetaExternal = driveMeta.getCompound("External");
                for (String key : driveMetaExternal.getAllKeys()) {
                    long lastAccessed = driveMetaExternal.getLong(key);
                    if (lastAccessed <= 0L) continue;
                    UUID uuid = UUID.fromString(key);
                    LAST_ACCESS_TIMES.put(uuid, lastAccessed);
                }
            }
        }
    }

    public static void saveDriveMeta() {
        CompoundTag driveMeta = new CompoundTag();
        CompoundTag driveMetaInternal = new CompoundTag();
        for (UUID uUID : INTERNAL_DRIVES.keySet()) {
            long lastAccessed = INTERNAL_DRIVES.get(uUID).getLastAccessed();
            if (lastAccessed <= 0L) continue;
            driveMetaInternal.putLong(uUID.toString(), lastAccessed);
        }
        driveMeta.put("Internal", (Tag)driveMetaInternal);
        CompoundTag driveMetaExternal = new CompoundTag();
        for (UUID uuid : EXTERNAL_DRIVES.keySet()) {
            long lastAccessed = EXTERNAL_DRIVES.get(uuid).getLastAccessed();
            if (lastAccessed <= 0L) continue;
            driveMetaExternal.putLong(uuid.toString(), lastAccessed);
        }
        driveMeta.put("External", (Tag)driveMetaExternal);
        Path path = UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drive_meta.dat");
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                UltreonDevices.LOGGER.error("Failed to create drive meta directory!", (Throwable)e);
            }
        }
        try {
            NbtIo.writeCompressed((CompoundTag)driveMeta, (Path)path);
        }
        catch (IOException e) {
            UltreonDevices.LOGGER.error("Failed to save drive meta!", (Throwable)e);
        }
    }

    @Deprecated
    public static void removeAllDrives() {
        for (UUID uuid : INTERNAL_DRIVES.keySet()) {
            DriveManager.removeDrive(uuid);
        }
        for (UUID uuid : EXTERNAL_DRIVES.keySet()) {
            DriveManager.removeDrive(uuid);
        }
    }

    public static void removeOldDrives(Duration duration) {
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Long> entry : LAST_ACCESS_TIMES.entrySet()) {
            if (now - entry.getValue() <= duration.toMillis()) continue;
            DriveManager.removeDrive(entry.getKey());
        }
    }

    public static void updateLastAccessed(UUID uuid, long lastAccessed) {
        LAST_ACCESS_TIMES.put(uuid, lastAccessed);
    }
}

