/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.object.ColorScheme;
import dev.ultreon.devices.programs.system.object.Preset;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class Settings {
    private static boolean showAllApps = true;
    private ColorScheme colorScheme = new ColorScheme();
    @Nullable
    private Preset preset = null;

    public static void setShowAllApps(boolean showAllApps) {
        Settings.showAllApps = showAllApps;
    }

    public static boolean isShowAllApps() {
        return showAllApps;
    }

    public ColorScheme getColorScheme() {
        if (this.colorScheme == null) {
            this.colorScheme = new ColorScheme();
        }
        if (this.preset == null) {
            return this.colorScheme;
        }
        ColorScheme presetColorScheme = this.preset.colorScheme();
        return presetColorScheme == null ? this.colorScheme : presetColorScheme;
    }

    public Preset getPreset() {
        return this.preset;
    }

    public void setPreset(Preset preset) {
        this.preset = preset;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("showAllApps", showAllApps);
        tag.put("colorScheme", (Tag)this.colorScheme.toTag());
        if (this.preset != null) {
            tag.put("preset", this.preset.toTag());
        }
        tag.put("tints", (Tag)this.appTintInfo());
        return tag;
    }

    private CompoundTag appTintInfo() {
        CompoundTag ct = new CompoundTag();
        for (AppInfo installedApplication : ComputerScreen.getSystem().getInstalledApplications()) {
            ct.put(installedApplication.getId().toString(), (Tag)installedApplication.getTintProvider().toTag());
        }
        return ct;
    }

    public static Settings fromTag(CompoundTag tag) {
        Settings settings = new Settings();
        settings.colorScheme = ColorScheme.fromTag(tag.getCompound("colorScheme"));
        settings.preset = tag.contains("preset", 10) ? Preset.fromTag(tag.getCompound("preset")) : null;
        return settings;
    }
}

