/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.TrayItemAdder;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.event.client.ComputerTrayItemsEvent;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Settings;
import dev.ultreon.devices.core.network.TrayItemWifi;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.object.TrayItem;
import dev.ultreon.devices.programs.system.AppStore;
import dev.ultreon.devices.programs.system.FileBrowserApp;
import dev.ultreon.devices.programs.system.SettingsApp;
import dev.ultreon.devices.programs.system.SystemApp;
import dev.ultreon.devices.util.Vulnerability;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TaskBar {
    public static final ResourceLocation APP_BAR_GUI = ResourceLocation.parse((String)"devices:textures/gui/application_bar.png");
    public static final int BAR_HEIGHT = 18;
    private static final int APPS_DISPLAYED = UltreonDevices.DEVELOPER_MODE ? 18 : 10;
    private final CompoundTag tag;
    private final ComputerScreen computerScreen;
    private final int offset = 0;
    private final List<TrayItem> trayItems = new ArrayList<TrayItem>();
    private static final Marker MARKER = MarkerFactory.getMarker((String)"TaskBar");

    @Deprecated
    public TaskBar(ComputerScreen computerScreen) {
        this(computerScreen, new CompoundTag());
    }

    public TaskBar(ComputerScreen computerScreen, CompoundTag tag) {
        this.computerScreen = computerScreen;
        this.tag = tag;
        CompoundTag trayItemsTag = tag.getCompound("TrayItems");
        this.addTrayItem(new Vulnerability.VulnerabilityTrayItem(), trayItemsTag);
        this.addTrayItem(new FileBrowserApp.FileBrowserTrayItem(), trayItemsTag);
        this.addTrayItem(new SettingsApp.SettingsTrayItem(), trayItemsTag);
        this.addTrayItem(new AppStore.StoreTrayItem(), trayItemsTag);
        this.addTrayItem(new TrayItemWifi(), trayItemsTag);
        TrayItemAdder trayItemAdder = new TrayItemAdder(this.trayItems);
        EventSystem.MAIN.publish((Object)new ComputerTrayItemsEvent(computerScreen, trayItemAdder));
    }

    public void addTrayItem(TrayItem trayItem, CompoundTag tag) {
        this.trayItems.add(trayItem);
        String strId = trayItem.getId().toString();
        if (tag.contains(strId, 10)) {
            CompoundTag trayTag = tag.getCompound(strId);
            trayItem.deserialize(trayTag);
        }
    }

    public void init() {
        this.trayItems.forEach(TrayItem::init);
    }

    public void setupApplications(List<Application> applications) {
        Predicate<Application> VALID_APPS = app -> {
            if (app instanceof SystemApp) {
                return true;
            }
            if (UltreonDevices.hasAllowedApplications()) {
                if (UltreonDevices.getAllowedApplications().contains(app.getInfo())) {
                    return !UltreonDevices.DEVELOPER_MODE || Settings.isShowAllApps();
                }
                return false;
            }
            if (UltreonDevices.DEVELOPER_MODE) {
                return Settings.isShowAllApps();
            }
            return true;
        };
    }

    public void init(int posX, int posY) {
        this.init();
    }

    public void onTick() {
        this.trayItems.forEach(TrayItem::tick);
    }

    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int appIndex;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)APP_BAR_GUI);
        Color bgColor = new Color(computerScreen.getSettings().getColorScheme().getBackgroundColor());
        float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
        bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        RenderSystem.setShaderColor((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
        int trayItemsWidth = this.trayItems.size() * 14;
        graphics.blit(APP_BAR_GUI, x, y, 1, 18, 0.0f, 0.0f, 1, 18, 256, 256);
        graphics.blit(APP_BAR_GUI, x + 1, y, ComputerScreen.getScreenWidth() - 36 - trayItemsWidth, 18, 1.0f, 0.0f, 1, 18, 256, 256);
        graphics.blit(APP_BAR_GUI, x + ComputerScreen.getScreenWidth() - 35 - trayItemsWidth, y, 35 + trayItemsWidth, 18, 2.0f, 0.0f, 1, 18, 256, 256);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < APPS_DISPLAYED && i < computerScreen.installedApps.size(); ++i) {
            AppInfo info = computerScreen.installedApps.get(i + 0);
            RenderUtil.drawApplicationIcon(graphics, info, x + 2 + i * 16, y + 2);
            if (!computerScreen.isApplicationRunning(info)) continue;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)APP_BAR_GUI);
            graphics.blit(APP_BAR_GUI, x + 1 + i * 16, y + 1, 35, 0, 16, 16);
        }
        assert (mc.level == null || mc.player != null);
        graphics.drawString(mc.font, this.timeToString(mc.level != null ? mc.level.getDayTime() : 0L), x + ComputerScreen.getScreenWidth() - 31, y + 5, Color.WHITE.getRGB(), true);
        int startX = x + ComputerScreen.getScreenWidth() - 48;
        for (int i = 0; i < this.trayItems.size(); ++i) {
            int posX = startX - (this.trayItems.size() - 1 - i) * 14;
            if (this.isMouseInside(mouseX, mouseY, posX, y + 2, posX + 13, y + 15)) {
                graphics.fill(posX, y + 2, posX + 14, y + 16, new Color(1.0f, 1.0f, 1.0f, 0.1f).getRGB());
            }
            this.trayItems.get(i).getIcon().draw(graphics, mc, posX + 2, y + 4);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)APP_BAR_GUI);
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16) && (appIndex = (mouseX - x - 1) / 16) >= 0 && appIndex < 0 + APPS_DISPLAYED && appIndex < computerScreen.installedApps.size()) {
            graphics.blit(APP_BAR_GUI, x + appIndex * 16 + 1, y + 1, 35, 0, 16, 16);
            computerScreen.renderComponentTooltip(graphics, List.of(Component.literal((String)computerScreen.installedApps.get(appIndex).getName())), mouseX, mouseY);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void handleClick(ComputerScreen computerScreen, int x, int y, int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16)) {
            UltreonDevices.LOGGER.debug(MARKER, "Clicked on task bar");
            int appIndex = (mouseX - x - 1) / 16;
            if (appIndex >= 0 && appIndex <= 0 + APPS_DISPLAYED && appIndex < computerScreen.installedApps.size()) {
                computerScreen.launchApp(computerScreen.installedApps.get(appIndex));
                return;
            }
        }
        int startX = x + ComputerScreen.getScreenWidth() - 48;
        for (int i = 0; i < this.trayItems.size(); ++i) {
            int posX = startX - (this.trayItems.size() - 1 - i) * 14;
            if (!this.isMouseInside(mouseX, mouseY, posX, y + 2, posX + 13, y + 15)) continue;
            TrayItem trayItem = this.trayItems.get(i);
            trayItem.handleClick(mouseX, mouseY, mouseButton);
            UltreonDevices.LOGGER.debug(MARKER, "Clicked on tray item (%d): %s".formatted(i, trayItem.getClass().getSimpleName()));
            break;
        }
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public String timeToString(long time) {
        int hours = (int)((Math.floor((double)time / 1000.0) + 6.0) % 24.0);
        int minutes = (int)Math.floor((double)(time % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public ComputerScreen getLaptop() {
        return this.computerScreen;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        CompoundTag trayItemsTag = new CompoundTag();
        for (TrayItem trayItem : this.trayItems) {
            trayItemsTag.put(trayItem.getId().toString(), (Tag)trayItem.serialize());
        }
        tag.put("TrayItems", (Tag)trayItemsTag);
        return tag;
    }
}

