/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.io.FSResponse;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.block.entity.DriveInfo;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.DriveManager;
import dev.ultreon.devices.core.Ext2FS;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.ServerFolder;
import dev.ultreon.devices.core.io.action.FileAction;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.core.io.drive.ExternalDrive;
import dev.ultreon.devices.core.io.drive.InternalDrive;
import dev.ultreon.devices.core.io.task.TaskGetMainDrive;
import dev.ultreon.devices.core.io.task.TaskSendAction;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.init.DeviceDataComponents;
import dev.ultreon.devices.init.DeviceItems;
import dev.ultreon.devices.item.FlashDriveItem;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FileSystem {
    public static final Pattern PATTERN_FILE_NAME = Pattern.compile("^[\\w'.:_ ]{1,32}$");
    public static final Pattern PATTERN_DIRECTORY = Pattern.compile("^(/)|(/[\\w'.:_ ]{1,32})*$");
    public static final Path DIR_ROOT = Path.of("/");
    public static final Path DIR_APPLICATION_DATA = Path.of("/ApplicationData");
    public static final Path DIR_HOME = Path.of("/Home");
    public static final String LAPTOP_DRIVE_NAME = "Main";
    private AbstractDrive mainDrive = null;
    private final Map<UUID, AbstractDrive> additionalDrives = new HashMap<UUID, AbstractDrive>();
    private AbstractDrive attachedDrive = null;
    private DyeColor attachedDriveColor = DyeColor.WHITE;
    private final ComputerBlockEntity blockEntity;

    public FileSystem(ComputerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.setupDefault();
    }

    public FileSystem(ComputerBlockEntity blockEntity, CompoundTag tag) {
        this.blockEntity = blockEntity;
        this.load(tag);
    }

    @Deprecated
    public static void sendAction(UUID drive, FileAction<?> action, @Nullable Callback<Response> callback) {
        if (ComputerScreen.getPos() != null) {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive));
            TaskSendAction task = new TaskSendAction(drive, action);
            task.setCallback((tag, success) -> {
                DebugLog.log("Action " + String.valueOf(action) + " sent to " + String.valueOf(drive) + ": " + success);
                if (callback != null) {
                    assert (tag != null);
                    Tag response = tag.get("response");
                    DebugLog.log("Callback: " + String.valueOf(response == null ? "null" : response));
                    callback.execute(Response.fromTag(tag.getCompound("response")), success);
                }
            });
            TaskManager.sendTask(task);
        } else {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive) + " failed: Laptop not found");
        }
    }

    public static <T> void request(UUID drive, FileAction<T> action, @Nullable Consumer<FSResponse<T>> callback) {
        if (ComputerScreen.getPos() != null) {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive));
            TaskSendAction task = new TaskSendAction(drive, action);
            task.setCallback((tag, success) -> {
                DebugLog.log("Action " + String.valueOf(action) + " sent to " + String.valueOf(drive) + ": " + success);
                if (callback != null) {
                    int status;
                    assert (tag != null);
                    CompoundTag response = tag.getCompound("response");
                    DebugLog.log("Callback: " + String.valueOf(response));
                    int n = status = response.contains("status", 3) ? response.getInt("status") : 0;
                    if (status != 1) {
                        success = false;
                    }
                    callback.accept(new FSResponse<Object>(success, status, (success ? (Object)action.deserialize(response.getCompound("data")) : null), response.getString("message")));
                }
            });
            TaskManager.sendTask(task);
        } else {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive) + " failed: Laptop not found");
        }
    }

    public static void getApplicationFolder(Application app, Consumer<FSResponse<FileInfo>> callback) {
        if (UltreonDevices.hasAllowedApplications() && !UltreonDevices.getAllowedApplications().contains(app.getInfo())) {
            callback.accept(new FSResponse<Object>(false, 8, null, "Application not allowed"));
            return;
        }
        if (ComputerScreen.getMainDrive() == null) {
            TaskGetMainDrive task = new TaskGetMainDrive(ComputerScreen.getPos());
            task.setCallback((tag, success) -> {
                if (success) {
                    FileSystem.setupApplicationFolder(app, callback);
                } else {
                    callback.accept(new FSResponse<Object>(false, 7, null, "Drive unavailable"));
                }
            });
            TaskManager.sendTask(task);
        } else {
            FileSystem.setupApplicationFolder(app, callback);
        }
    }

    private static void setupApplicationFolder(Application app, Consumer<FSResponse<FileInfo>> callback) {
        Drive mainDrive = ComputerScreen.getMainDrive();
        assert (mainDrive != null);
        mainDrive.info(DIR_APPLICATION_DATA.resolve(app.getInfo().getFormattedId()), info -> mainDrive.exists(DIR_APPLICATION_DATA.resolve(app.getInfo().getFormattedId()), appDirExist -> {
            if (!((Boolean)appDirExist.data()).booleanValue()) {
                ((FileInfo)info.data()).createDirectory(app.getInfo().getFormattedId(), callback);
                return;
            }
            callback.accept(new FSResponse<Object>(false, 0, null, "Application folder still does not exist"));
        }));
    }

    public static Response createSuccessResponse() {
        return new Response(1);
    }

    public static Response createResponse(int status, String message) {
        return new Response(status, message);
    }

    public static Response createResponse(int status, String message, CompoundTag data) {
        return new Response(status, message, data);
    }

    public static UUID getMainDriveId() {
        if (ComputerScreen.getMainDrive() != null) {
            return ComputerScreen.getMainDrive().getUUID();
        }
        return null;
    }

    private void load(CompoundTag tag) {
        if (tag.contains("main_drive", 10)) {
            this.mainDrive = InternalDrive.fromTag(tag.getCompound("main_drive"));
        }
        if (tag.contains("drives", 9)) {
            ListTag list = tag.getList("drives", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag driveTag = list.getCompound(i);
                AbstractDrive drive = InternalDrive.fromTag(driveTag.getCompound("drive"));
                this.additionalDrives.put(drive.getUuid(), drive);
            }
        }
        if (tag.contains("external_drive", 10)) {
            this.attachedDrive = ExternalDrive.fromTag(tag.getCompound("external_drive"));
        }
        if (tag.contains("external_drive_color", 1)) {
            this.attachedDriveColor = DyeColor.byId((int)tag.getByte("external_drive_color"));
        }
        this.setupDefault();
    }

    private void setupDefault() {
        if (this.mainDrive == null) {
            this.mainDrive = new InternalDrive(LAPTOP_DRIVE_NAME);
            this.blockEntity.setChanged();
        }
    }

    @Deprecated
    private ServerFolder createProtectedFolder(String name) {
        try {
            Constructor constructor = ServerFolder.class.getDeclaredConstructor(String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (ServerFolder)constructor.newInstance(name, true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean createSystemDirectory(String name) {
        try {
            Ext2FS fs = this.mainDrive.getFS();
            Path path = Path.of(name);
            fs.createDirectory(path);
            fs.setReadOnly(path, true);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Response readAction(UUID driveUuid, FileAction<?> action, Level level) {
        AbstractDrive drive = this.getAvailableDrives(level, true).get(driveUuid);
        if (drive != null) {
            Response response = drive.handleFileAction(this, action, level);
            if (response.getStatus() == 1) {
                this.blockEntity.setChanged();
            }
            return response;
        }
        return FileSystem.createResponse(7, "Drive unavailable or missing");
    }

    public AbstractDrive getMainDrive() {
        return this.mainDrive;
    }

    public Map<UUID, AbstractDrive> getAvailableDrives(@Nullable Level level, boolean includeMain) {
        LinkedHashMap<UUID, AbstractDrive> drives = new LinkedHashMap<UUID, AbstractDrive>();
        if (includeMain && this.mainDrive != null) {
            drives.put(this.mainDrive.getUuid(), this.mainDrive);
        }
        drives.putAll(this.additionalDrives);
        if (this.attachedDrive != null) {
            drives.put(this.attachedDrive.getUuid(), this.attachedDrive);
        }
        return drives;
    }

    public AbstractDrive getAttachedDrive() {
        return this.attachedDrive;
    }

    public DyeColor getAttachedDriveColor() {
        return this.attachedDriveColor;
    }

    public boolean attachDrive(ItemStack flashDrive) {
        Item item = flashDrive.getItem();
        if (item instanceof FlashDriveItem) {
            ExternalDrive drive;
            FlashDriveItem flashDriveItem = (FlashDriveItem)item;
            if (this.attachedDrive == null && (drive = FileSystem.getExternalDrive(flashDrive)) != null) {
                drive.setName(flashDrive.getHoverName().getString());
                this.attachedDrive = drive;
                this.attachedDriveColor = flashDriveItem.getColor();
                this.blockEntity.getPipeline().putByte("external_drive_color", (byte)this.attachedDriveColor.getId());
                this.blockEntity.sync();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ItemStack detachDrive() {
        if (this.attachedDrive != null) {
            ItemStack stack = new ItemStack((ItemLike)DeviceItems.getFlashDriveByColor(this.attachedDriveColor), 1);
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.attachedDrive.getName()));
            stack.set((DataComponentType)DeviceDataComponents.DISK.get(), (Object)this.attachedDrive.getUuid());
            this.attachedDrive = null;
            return stack;
        }
        return null;
    }

    @Deprecated
    public static CompoundTag getExternalDriveTag(ItemStack stack) {
        if (!stack.has((DataComponentType)DeviceDataComponents.DISK.get())) {
            ExternalDrive externalDrive = new ExternalDrive(stack.getDisplayName().getString());
            stack.set((DataComponentType)DeviceDataComponents.DISK.get(), (Object)externalDrive.getUuid());
        }
        return new CompoundTag();
    }

    public static UUID getExternalDriveId(ItemStack stack) {
        if (!stack.has((DataComponentType)DeviceDataComponents.DISK.get())) {
            ExternalDrive externalDrive = new ExternalDrive(stack.getDisplayName().getString());
            stack.set((DataComponentType)DeviceDataComponents.DISK.get(), (Object)externalDrive.getUuid());
            return externalDrive.getUuid();
        }
        return (UUID)stack.get((DataComponentType)DeviceDataComponents.DISK.get());
    }

    public static ExternalDrive getExternalDrive(ItemStack stack) {
        if (stack.has((DataComponentType)DeviceDataComponents.DISK.get())) {
            UUID uuid = (UUID)stack.get((DataComponentType)DeviceDataComponents.DISK.get());
            return DriveManager.getExternalDrive(uuid);
        }
        ExternalDrive externalDrive = new ExternalDrive(stack.getDisplayName().getString());
        DriveManager.registerExternalDrive(externalDrive);
        stack.set((DataComponentType)DeviceDataComponents.DISK.get(), (Object)externalDrive.getUuid());
        return externalDrive;
    }

    public CompoundTag toTag() {
        CompoundTag fileSystemTag = new CompoundTag();
        if (this.mainDrive != null) {
            fileSystemTag.put("main_drive", (Tag)this.mainDrive.toTag());
        }
        ListTag list = new ListTag();
        this.additionalDrives.forEach((k, v) -> list.add((Object)v.toTag()));
        fileSystemTag.put("drives", (Tag)list);
        if (this.attachedDrive != null) {
            fileSystemTag.put("external_drive", (Tag)this.attachedDrive.toTag());
            fileSystemTag.putByte("external_drive_color", (byte)this.attachedDriveColor.getId());
        }
        return fileSystemTag;
    }

    public Map<UUID, DriveInfo> getDrives() {
        HashMap<UUID, DriveInfo> drives = new HashMap<UUID, DriveInfo>();
        if (this.mainDrive != null) {
            drives.put(this.mainDrive.getUuid(), new DriveInfo(this.mainDrive.getName(), this.mainDrive.getUuid(), Drive.Type.INTERNAL, true));
        }
        this.additionalDrives.forEach((k, v) -> drives.put(v.getUuid(), new DriveInfo(v.getName(), v.getUuid(), Drive.Type.INTERNAL)));
        if (this.attachedDrive != null) {
            drives.put(this.attachedDrive.getUuid(), new DriveInfo(this.attachedDrive.getName(), this.attachedDrive.getUuid(), Drive.Type.EXTERNAL));
        }
        return drives;
    }

    public static final class Status {
        public static final int FAILED = 0;
        public static final int SUCCESSFUL = 1;
        public static final int FILE_INVALID = 2;
        public static final int FILE_IS_PROTECTED = 3;
        public static final int FILE_EXISTS = 4;
        public static final int FILE_INVALID_NAME = 5;
        public static final int FILE_INVALID_DATA = 6;
        public static final int DRIVE_UNAVAILABLE = 7;
        public static final int ACCESS_DENIED = 8;
        public static final int TOO_LARGE = 9;
        public static final int FILE_DOES_NOT_EXIST = 10;
    }

    public static class Response {
        private final int status;
        private String message = "";
        private CompoundTag data = new CompoundTag();

        private Response(int status) {
            this.status = status;
        }

        private Response(int status, String message) {
            this.status = status;
            this.message = message;
        }

        private Response(int status, String message, CompoundTag data) {
            this.status = status;
            this.message = message;
            this.data = data;
        }

        public static Response fromTag(CompoundTag responseTag) {
            return new Response(responseTag.getInt("status"), responseTag.getString("message"), responseTag.getCompound("data"));
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public CompoundTag getData() {
            return this.data;
        }

        public CompoundTag toTag() {
            CompoundTag responseTag = new CompoundTag();
            responseTag.putInt("status", this.status);
            responseTag.putString("message", this.message);
            responseTag.put("data", (Tag)this.data);
            return responseTag;
        }
    }
}

