/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io;

import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Path
implements Iterable<String> {
    private final String[] path;

    private Path(String[] split) {
        if (split.length == 0) {
            throw new IllegalArgumentException("Path must be absolute!");
        }
        if (!split[0].isEmpty()) {
            throw new IllegalArgumentException("Path must be absolute!");
        }
        this.path = split;
        for (int i = 1; i < split.length; ++i) {
            if (split[i].isEmpty()) {
                throw new IllegalArgumentException("Path must not contain empty segments");
            }
            if (!split[i].contains("/")) continue;
            throw new IllegalArgumentException("Path must not contain any slashes!");
        }
    }

    public static Path of(String s) {
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return new Path(s.split("/"));
    }

    public String toString() {
        return String.join((CharSequence)"/", this.path);
    }

    public String[] getNames() {
        return this.path;
    }

    public Path resolve(String formattedId) {
        return Path.of(String.valueOf(this) + "/" + formattedId);
    }

    public Path getParent() {
        if (this.path.length == 1) {
            return null;
        }
        return Path.of(String.join((CharSequence)"/", Arrays.copyOfRange(this.path, 0, this.path.length - 1)));
    }

    public String getFileName() {
        if (this.path.length == 1) {
            return "/";
        }
        return this.path[this.path.length - 1];
    }

    public boolean endsWith(String s) {
        return this.toString().endsWith(s);
    }

    public Path resolveSibling(String name) {
        String[] newPath = new String[this.path.length];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length - 1);
        newPath[newPath.length - 1] = name;
        return new Path(newPath);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int i = 1;

            @Override
            public boolean hasNext() {
                return this.i < Path.this.path.length;
            }

            @Override
            public String next() {
                return Path.this.path[this.i++];
            }
        };
    }
}

