/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.io.MimeType;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.ServerFolder;
import java.util.Comparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public sealed class ServerFile
permits ServerFolder {
    public static final Comparator<ServerFile> SORT_BY_NAME = (f1, f2) -> {
        if (f1.isFolder() && !f2.isFolder()) {
            return -1;
        }
        if (!f1.isFolder() && f2.isFolder()) {
            return 1;
        }
        return f1.name.compareTo(f2.name);
    };
    private MimeType mimeType = MimeType.APPLICATION_OCTET_STREAM;
    protected ServerFolder parent;
    protected String name;
    protected String openingApp;
    protected CompoundTag data;
    protected boolean protect = false;
    protected long lastModified;
    protected long lastAccessed;
    protected long creationTime;

    protected ServerFile() {
    }

    public ServerFile(String name, Application app, CompoundTag data) {
        this(name, app.getInfo().getFormattedId(), data, false);
    }

    public ServerFile(String name, String openingAppId, CompoundTag data) {
        this(name, openingAppId, data, false);
    }

    public ServerFile(String name, String openingAppId, MimeType mimeType, CompoundTag data) {
        this(name, openingAppId, data, mimeType, false);
    }

    private ServerFile(String name, String openingAppId, CompoundTag data, boolean protect) {
        this(name, openingAppId, data, MimeType.APPLICATION_OCTET_STREAM, protect);
    }

    private ServerFile(String name, String openingAppId, CompoundTag data, MimeType mimeType, boolean protect) {
        this.name = name;
        this.openingApp = openingAppId;
        this.data = data;
        this.mimeType = mimeType;
        this.protect = protect;
        this.lastModified = this.creationTime = System.currentTimeMillis();
        this.lastAccessed = this.creationTime;
    }

    private ServerFile(String name, boolean protect, CompoundTag tag) {
        this.openingApp = tag.getString("openingApp");
        this.name = name;
        this.data = tag.getCompound("data");
        this.creationTime = tag.getLong("creationTime");
        this.lastModified = tag.getLong("lastModified");
        this.lastAccessed = tag.getLong("lastAccessed");
        this.protect = protect;
        this.mimeType = MimeType.of(tag.getCompound("mimeType"));
    }

    public String getName() {
        return this.name;
    }

    public FileSystem.Response rename(String name) {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot rename a protected file");
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(name).matches()) {
            return FileSystem.createResponse(5, "Invalid file name");
        }
        this.name = name;
        this.lastModified = System.currentTimeMillis();
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public String getOpeningApp() {
        return this.openingApp;
    }

    public FileSystem.Response setData(CompoundTag data) {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot set data on a protected file");
        }
        if (data == null) {
            return FileSystem.createResponse(6, "Invalid data");
        }
        this.data = data;
        this.lastModified = System.currentTimeMillis();
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public CompoundTag getData() {
        CompoundTag data1 = this.data.copy();
        this.lastAccessed = System.currentTimeMillis();
        return data1;
    }

    @Nullable
    public ServerFolder getParent() {
        return this.parent;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public boolean isFolder() {
        return false;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public boolean isForApplication(Application app) {
        return this.openingApp != null && this.openingApp.equals(app.getInfo().getFormattedId());
    }

    public FileSystem.Response delete() {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot delete a protected file");
        }
        if (this.parent != null) {
            return this.parent.delete(this);
        }
        return FileSystem.createResponse(2, "Invalid file");
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("openingApp", this.openingApp);
        tag.putLong("lastModified", this.lastModified);
        tag.putLong("lastAccessed", this.lastAccessed);
        tag.putLong("creationTime", this.creationTime);
        tag.put("data", (Tag)this.data);
        return tag;
    }

    public static ServerFile fromTag(String name, CompoundTag tag) {
        return new ServerFile(name, false, tag);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerFile)) {
            return false;
        }
        return ((ServerFile)obj).name.equalsIgnoreCase(this.name);
    }

    public ServerFile copy() {
        return new ServerFile(this.name, this.openingApp, this.data.copy());
    }

    void onCreate() {
        this.creationTime = System.currentTimeMillis();
    }
}

