/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io;

import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.ServerFile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerFolder
extends ServerFile {
    private List<ServerFile> files = new ArrayList<ServerFile>();
    private final Object interrupt = new Object();

    public ServerFolder(String name) {
        this(name, false);
    }

    private ServerFolder(String name, boolean protect) {
        this.name = name;
        this.protect = protect;
    }

    private ServerFolder(String name, boolean protect, CompoundTag tag) {
        this.name = name;
        this.protect = protect;
        this.creationTime = tag.getLong("creationTime");
        this.lastModified = tag.getLong("lastModified");
        this.lastAccessed = tag.getLong("lastAccessed");
    }

    public static ServerFolder fromTag(String name, CompoundTag folderTag) {
        ServerFolder folder = new ServerFolder(name, false, folderTag);
        if (folderTag.contains("protected", 1)) {
            folder.protect = folderTag.getBoolean("protected");
        }
        CompoundTag fileList = folderTag.getCompound("files");
        for (String fileName : fileList.getAllKeys()) {
            CompoundTag fileTag = fileList.getCompound(fileName);
            if (fileTag.contains("files")) {
                folder.add(ServerFolder.fromTag(fileName, fileTag), false);
                continue;
            }
            folder.add(ServerFile.fromTag(fileName, fileTag), false);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem.Response add(ServerFile file, boolean override) {
        if (file == null) {
            return FileSystem.createResponse(2, "Illegal file");
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(file.getName()).matches()) {
            return FileSystem.createResponse(5, "Invalid file name");
        }
        Object object = this.interrupt;
        synchronized (object) {
            ServerFile child = this.getFile(file.name);
            if (child != null) {
                if (!override) {
                    return FileSystem.createResponse(4, "A file with that name already exists");
                }
                if (child.isProtected()) {
                    return FileSystem.createResponse(3, "Unable to override protected files");
                }
                this.files.remove(child);
            }
            this.files.add(file);
            file.parent = this;
            file.onCreate();
        }
        return FileSystem.createSuccessResponse();
    }

    public FileSystem.Response delete(String name) {
        return this.delete(this.getFile(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem.Response delete(ServerFile file) {
        if (file == null) {
            return FileSystem.createResponse(2, "Illegal file");
        }
        Object object = this.interrupt;
        synchronized (object) {
            if (!this.files.contains(file)) {
                return FileSystem.createResponse(2, "The file does not exist in this folder");
            }
            if (file.isProtected()) {
                return FileSystem.createResponse(3, "Cannot delete protected files");
            }
            file.parent = null;
            this.files.remove(file);
        }
        return FileSystem.createSuccessResponse();
    }

    public boolean hasFile(String name) {
        return this.files.stream().anyMatch(file -> file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public ServerFile getFile(String name) {
        return this.files.stream().filter(file -> file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public boolean hasFolder(String name) {
        return this.files.stream().anyMatch(file -> file.isFolder() && file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public ServerFolder getFolder(String name) {
        return this.files.stream().filter(file -> file.isFolder() && file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<ServerFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<ServerFile> files) {
        this.files = files;
    }

    public List<ServerFile> search(Predicate<ServerFile> conditions, boolean includeSubServerFolders) {
        NonNullList found = NonNullList.create();
        this.search((List<ServerFile>)found, conditions, includeSubServerFolders);
        return found;
    }

    private void search(List<ServerFile> results, Predicate<ServerFile> conditions, boolean includeSubServerFolders) {
        this.files.forEach(file -> {
            if (file.isFolder()) {
                if (includeSubServerFolders) {
                    ((ServerFolder)file).search(results, conditions, true);
                }
            } else if (conditions.test((ServerFile)file)) {
                results.add((ServerFile)file);
            }
        });
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag folderTag = new CompoundTag();
        CompoundTag fileList = new CompoundTag();
        this.files.forEach(file -> fileList.put(file.getName(), (Tag)file.toTag()));
        folderTag.put("files", (Tag)fileList);
        if (this.protect) {
            folderTag.putBoolean("protected", true);
        }
        folderTag.putLong("creationTime", this.creationTime);
        folderTag.putLong("lastModified", this.lastModified);
        folderTag.putLong("lastAccessed", this.lastAccessed);
        return folderTag;
    }

    @Override
    public FileSystem.Response setData(@NotNull CompoundTag data) {
        return FileSystem.createResponse(6, "Data can not be set to a folder");
    }

    @Override
    public ServerFile copy() {
        ServerFolder folder = new ServerFolder(this.name);
        this.files.forEach(f -> {
            ServerFile copy = f.copy();
            copy.protect = false;
            folder.add(copy, false);
        });
        return folder;
    }

    public ServerFolder copyStructure() {
        ServerFolder folder = new ServerFolder(this.name, this.protect);
        this.files.forEach(f -> {
            if (f.isFolder()) {
                folder.add(((ServerFolder)f).copyStructure(), false);
            }
        });
        return folder;
    }
}

