/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.action;

import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.action.ModNbtUtils;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Unit;

public record FileAction<T>(Type type, CompoundTag data, Function<CompoundTag, T> deserializer) {
    public static final Function<CompoundTag, Object> NULL = tag1 -> null;

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("type", this.type.ordinal());
        tag.put("data", (Tag)this.data);
        return tag;
    }

    public static FileAction<?> fromTag(CompoundTag tag) {
        Type type = Type.values()[tag.getInt("type")];
        CompoundTag data = tag.getCompound("data");
        return new FileAction<Object>(type, data, NULL);
    }

    @Override
    public String toString() {
        return "FileAction{type=" + String.valueOf((Object)this.type) + "}";
    }

    public T deserialize(CompoundTag data) {
        if (this.deserializer == NULL) {
            throw new UnsupportedOperationException();
        }
        return this.deserializer.apply(data);
    }

    public static enum Type {
        NEW_FILE,
        NEW_FOLDER,
        DELETE,
        RENAME,
        WRITE,
        EXISTS,
        READ,
        LIST_DIR,
        INFO,
        MOVE,
        COPY,
        EXTRA_INFO,
        NEW_FOLDERS,
        COPY_CUT;

    }

    public static class Factory {
        public static FileAction<FileInfo> makeNewFile(Path parent, String name, boolean override) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", parent.resolve(name).toString());
            vars.putBoolean("override", override);
            vars.putByteArray("data", new byte[0]);
            return new FileAction<FileInfo>(Type.NEW_FILE, vars, FileInfo::fromTag);
        }

        public static FileAction<FileInfo> makeNewFolder(Path parent, String name, boolean override) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", parent.resolve(name).toString());
            vars.putBoolean("override", override);
            return new FileAction<FileInfo>(Type.NEW_FOLDER, vars, FileInfo::fromTag);
        }

        public static FileAction<Unit> makeDelete(Path file) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", file.toString());
            return new FileAction<Unit>(Type.DELETE, vars, tag -> Unit.INSTANCE);
        }

        public static FileAction<Unit> makeRename(Path file, String newFileName) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", file.toString());
            vars.putString("new_file_name", newFileName);
            return new FileAction<Unit>(Type.RENAME, vars, tag -> Unit.INSTANCE);
        }

        @Deprecated
        public static FileAction<Unit> makeData(Path file, CompoundTag data) throws IOException {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", file.toString());
            vars.putByteArray("data", ModNbtUtils.toBytes((Tag)data));
            return new FileAction<Unit>(Type.WRITE, vars, tag -> Unit.INSTANCE);
        }

        public static FileAction<FileInfo> makeWrite(Path file, long offset, byte[] data) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", file.toString());
            vars.putLong("offset", offset);
            vars.putByteArray("data", data);
            return new FileAction<FileInfo>(Type.WRITE, vars, FileInfo::fromTag);
        }

        @Deprecated
        public static FileAction<Unit> makeCopyCut(Path source, DataPath destination, boolean override, boolean cut) {
            CompoundTag vars = new CompoundTag();
            vars.putString("source", source.toString());
            vars.putString("destination_drive", destination.drive().toString());
            vars.putString("destination_folder", destination.path().toString());
            vars.putBoolean("override", override);
            vars.putBoolean("cut", cut);
            return new FileAction<Unit>(Type.COPY_CUT, vars, tag -> Unit.INSTANCE);
        }

        public static FileAction<Boolean> makeExists(Path path) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", path.toString());
            return new FileAction<Boolean>(Type.EXISTS, vars, tag -> tag.getBoolean("exists"));
        }

        public static FileAction<byte[]> makeRead(Path path) {
            return Factory.makeRead(path, -1L, -1);
        }

        public static FileAction<byte[]> makeRead(Path path, long offset, int length) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", path.toString());
            vars.putLong("offset", offset);
            vars.putInt("length", length);
            return new FileAction<byte[]>(Type.READ, vars, tag -> tag.getByteArray("data"));
        }

        public static FileAction<List<FileInfo>> makeList(Path path) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", path.toString());
            return new FileAction<List<FileInfo>>(Type.LIST_DIR, vars, tag -> {
                ArrayList<FileInfo> list = new ArrayList<FileInfo>();
                ListTag listTag = tag.getList("files", 10);
                for (Tag tag1 : listTag) {
                    if (!(tag1 instanceof CompoundTag)) continue;
                    CompoundTag compoundTag = (CompoundTag)tag1;
                    list.add(FileInfo.fromTag(compoundTag));
                }
                return list;
            });
        }

        public static FileAction<FileInfo> makeInfo(Path path) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", path.toString());
            return new FileAction<FileInfo>(Type.INFO, vars, FileInfo::fromTag);
        }

        public static FileAction<Unit> makeMove(Path source, Path destination, boolean override) {
            CompoundTag vars = new CompoundTag();
            vars.putString("source", source.toString());
            vars.putString("destination", destination.toString());
            vars.putBoolean("override", override);
            return new FileAction<Unit>(Type.MOVE, vars, tag -> Unit.INSTANCE);
        }

        public static FileAction<FileInfo> makeCopy(Path source, Path destination, boolean override) {
            CompoundTag vars = new CompoundTag();
            vars.putString("source", source.toString());
            vars.putString("destination", destination.toString());
            vars.putBoolean("override", override);
            return new FileAction<FileInfo>(Type.COPY, vars, FileInfo::fromTag);
        }

        public static FileAction<CompoundTag> makeExtraInfo(Path path) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", path.toString());
            return new FileAction<CompoundTag>(Type.EXTRA_INFO, vars, Function.identity());
        }

        public static FileAction<FileInfo> makeNewFolders(Path path) {
            CompoundTag vars = new CompoundTag();
            vars.putString("path", path.toString());
            return new FileAction<FileInfo>(Type.NEW_FOLDERS, vars, FileInfo::fromTag);
        }
    }
}

