/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.drive;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.DriveManager;
import dev.ultreon.devices.core.Ext2FS;
import dev.ultreon.devices.core.FS;
import dev.ultreon.devices.core.LockKey;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.ServerFolder;
import dev.ultreon.devices.core.io.action.FileAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jnode.fs.FileSystemException;

public abstract class AbstractDrive
implements FS {
    private boolean deferred;
    private Ext2FS fs;
    private boolean invalid = false;
    protected String name;
    protected UUID uuid;
    private boolean damaged;
    private long lastAccessed;

    AbstractDrive() {
        this(UUID.randomUUID());
    }

    AbstractDrive(UUID uuid) {
        this.name = "Drive";
        this.uuid = uuid;
        if (UltreonDevices.getServer() == null) {
            this.deferred = true;
            return;
        }
        try {
            java.nio.file.Path resolve = UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
            if (Files.notExists(resolve, new LinkOption[0])) {
                if (Files.notExists(resolve.getParent(), new LinkOption[0])) {
                    Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                }
                this.setFs(Ext2FS.format(resolve, 1L));
                this.setup();
            } else {
                this.setFs(Ext2FS.open(resolve));
            }
        }
        catch (IOException | FileSystemException e) {
            this.invalid = true;
            this.setFs(null);
        }
    }

    public static void deleteDrivePath(UUID uuid) {
        try {
            java.nio.file.Path resolve = UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
            if (Files.exists(resolve, new LinkOption[0])) {
                Files.delete(resolve);
            }
        }
        catch (IOException e) {
            UltreonDevices.LOGGER.error("Failed to delete drive path for drive {}", (Object)uuid, (Object)e);
        }
    }

    protected void setup() {
    }

    AbstractDrive(UUID uuid, java.nio.file.Path drivePath) throws FileSystemException, IOException {
        this.name = "OS";
        this.uuid = uuid;
        this.setFs(Ext2FS.open(drivePath));
    }

    AbstractDrive(String name) {
        this(name, UUID.randomUUID());
    }

    public AbstractDrive(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
        if (UltreonDevices.getServer() == null) {
            this.deferred = true;
            this.setFs(null);
            return;
        }
        try {
            java.nio.file.Path resolve = UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
            if (Files.notExists(resolve, new LinkOption[0])) {
                if (Files.notExists(resolve.getParent(), new LinkOption[0])) {
                    Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                }
                this.setFs(Ext2FS.format(resolve, 0x1000000L));
                this.setup();
            } else {
                this.setFs(Ext2FS.open(resolve));
            }
        }
        catch (IOException | FileSystemException e) {
            this.invalid = true;
            this.setFs(null);
        }
    }

    public static java.nio.file.Path getDrivePath(UUID uuid) {
        return UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
    }

    private void createProtectedFolder(Ext2FS fs, String name) {
        this.setLastAccessed(System.currentTimeMillis());
        try {
            Path path = Path.of(name);
            fs.createDirectory(path);
            fs.setReadOnly(path, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        this.setLastAccessed(System.currentTimeMillis());
        return this.name;
    }

    public void setName(String name) {
        this.setLastAccessed(System.currentTimeMillis());
        this.name = name;
    }

    public UUID getUuid() {
        this.setLastAccessed(System.currentTimeMillis());
        return this.uuid;
    }

    @Deprecated
    public ServerFolder getRoot(Level level) {
        this.setLastAccessed(System.currentTimeMillis());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem.Response handleFileAction(FileSystem fileSystem, FileAction action, Level level) {
        this.setLastAccessed(System.currentTimeMillis());
        CompoundTag actionData = action.data();
        LockKey lock = this.getFs().lock(actionData.getString("directory"));
        try {
            CompoundTag data = actionData.getCompound("data");
            FileSystem.Response response = switch (action.type()) {
                case FileAction.Type.NEW_FILE -> this.newFile(actionData, data);
                case FileAction.Type.NEW_FOLDER -> this.newFolder(actionData, data);
                case FileAction.Type.NEW_FOLDERS -> this.newFolders(actionData, data);
                case FileAction.Type.DELETE -> this.delete(actionData);
                case FileAction.Type.RENAME -> this.rename(actionData);
                case FileAction.Type.WRITE -> this.writeData(actionData, data);
                case FileAction.Type.EXISTS -> this.exists(actionData);
                case FileAction.Type.READ -> this.readData(actionData);
                case FileAction.Type.LIST_DIR -> this.listDir(actionData);
                case FileAction.Type.INFO -> this.info(actionData);
                case FileAction.Type.MOVE -> this.move(actionData);
                case FileAction.Type.COPY -> this.copy(actionData);
                case FileAction.Type.EXTRA_INFO -> this.extraInfo(actionData);
                default -> throw new IOException("Invalid FS action: " + String.valueOf((Object)action.type()));
            };
            if (lock != null) {
                this.getFs().unlock(actionData.getString("directory"));
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    this.getFs().unlock(actionData.getString("directory"));
                }
                throw throwable;
            }
            catch (IOException e) {
                return FileSystem.createResponse(2, "I/O error: " + e.getMessage());
            }
        }
    }

    private FileSystem.Response newFolders(CompoundTag actionData, CompoundTag data) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        String string = path.toString();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String[] folders = string.split("/");
        path = Path.of("/");
        for (int i = 0; i < folders.length; ++i) {
            path = path.resolve(folders[i]);
            try {
                if (this.getFs().exists(path)) continue;
                try {
                    this.getFs().createDirectory(path);
                    continue;
                }
                catch (IOException e) {
                    return FileSystem.createResponse(2, "Failed to create folder: " + e.getMessage());
                }
            }
            catch (IOException e) {
                return FileSystem.createResponse(2, "Failed to check folder: " + e.getMessage());
            }
        }
        return FileSystem.createResponse(1, "Created folder " + folders[folders.length - 1], this.info(path));
    }

    private CompoundTag info(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        CompoundTag data = new CompoundTag();
        CompoundTag drive = new CompoundTag();
        drive.putString("name", this.getName());
        drive.put("uuid", (Tag)NbtUtils.createUUID((UUID)this.getUuid()));
        drive.putByte("type", (byte)this.getType().ordinal());
        data.put("drive", (Tag)drive);
        data.putString("path", path.toString());
        data.putBoolean("protected", this.getFs().isReadOnly(path));
        data.putBoolean("folder", this.getFs().isFolder(path));
        data.putLong("size", this.getFs().size(path));
        return data;
    }

    private FileSystem.Response extraInfo(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't ex-stat file, file not found!");
        }
        CompoundTag data = new CompoundTag();
        data.putLong("size", this.getFs().size(path));
        data.putLong("lastModified", this.getFs().lastModified(path));
        data.putLong("lastAccessed", this.getFs().lastAccessed(path));
        data.putLong("creationTime", this.getFs().creationTime(path));
        return FileSystem.createResponse(1, "", data);
    }

    private FileSystem.Response move(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path source = Path.of(actionData.getString("source"));
        Path destination = Path.of(actionData.getString("destination"));
        if (!this.getFs().exists(source)) {
            return FileSystem.createResponse(2, "Can't move file, file not found!");
        }
        try {
            this.getFs().move(source, destination);
            return FileSystem.createSuccessResponse();
        }
        catch (IOException e) {
            return FileSystem.createResponse(2, "I/O error: " + e.getMessage());
        }
    }

    private FileSystem.Response copy(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path source = Path.of(actionData.getString("source"));
        Path destination = Path.of(actionData.getString("destination"));
        if (!this.getFs().exists(source)) {
            return FileSystem.createResponse(2, "Can't copy file, file not found!");
        }
        try {
            this.getFs().copy(source, destination);
            return FileSystem.createResponse(1, "", this.info(destination));
        }
        catch (IOException e) {
            return FileSystem.createResponse(2, "I/O error: " + e.getMessage());
        }
    }

    private FileSystem.Response info(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't stat file, file not found!");
        }
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private FileSystem.Response listDir(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't list directory, file not found!");
        }
        CompoundTag data = new CompoundTag();
        ListTag list = new ListTag();
        Iterator<String> iterator = this.getFs().listDirectory(path);
        while (iterator.hasNext()) {
            String child = iterator.next();
            list.add((Object)this.info(path.resolve(child)));
        }
        data.put("files", (Tag)list);
        return FileSystem.createResponse(1, "", data);
    }

    private FileSystem.Response readData(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't read file, file not found!");
        }
        long offset = actionData.getLong("offset");
        int length = actionData.getInt("length");
        if (offset < 0L || length < 0) {
            try (InputStream read = this.read(path, StandardOpenOption.READ);){
                CompoundTag data = new CompoundTag();
                data.putByteArray("data", read.readAllBytes());
                FileSystem.Response response = FileSystem.createResponse(1, "", data);
                return response;
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        this.fs.read(path, buffer, offset);
        buffer.flip();
        CompoundTag data = new CompoundTag();
        data.putByteArray("data", buffer.array());
        return FileSystem.createResponse(1, "", data);
    }

    private FileSystem.Response exists(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        boolean exists = this.getFs().exists(path);
        CompoundTag data = new CompoundTag();
        data.putBoolean("exists", exists);
        return FileSystem.createResponse(1, "", data);
    }

    private @NotNull FileSystem.Response newFile(CompoundTag actionData, CompoundTag data) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        boolean override = actionData.getBoolean("override");
        byte[] dataBytes = data.getByteArray("data");
        if (!override && this.getFs().exists(path)) {
            return FileSystem.createResponse(4, "File already exists");
        }
        if (this.getFS().exists(path)) {
            this.getFs().delete(path);
        }
        this.createFile(path, dataBytes);
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private @NotNull FileSystem.Response newFolder(CompoundTag actionData, CompoundTag data) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        if (path.toString().equals("/")) {
            throw new IOException("Can't create root folder");
        }
        boolean override = actionData.getBoolean("override");
        byte[] dataBytes = data.getByteArray("data");
        if (!override && this.getFs().exists(path)) {
            return FileSystem.createResponse(4, "File already exists");
        }
        this.createDirectory(path);
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private @NotNull FileSystem.Response delete(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "File not found on server. Please refresh!");
        }
        this.getFs().delete(path);
        return FileSystem.createSuccessResponse();
    }

    private @NotNull FileSystem.Response rename(CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        String newName = actionData.getString("new_name");
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "File not found on server. Please refresh!");
        }
        this.getFs().rename(path, newName);
        return FileSystem.createSuccessResponse();
    }

    private @NotNull FileSystem.Response writeData(CompoundTag actionData, CompoundTag data) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path path = Path.of(actionData.getString("path"));
        long offset = actionData.getLong("offset");
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(7, "Invalid directory");
        }
        byte[] dataBytes = actionData.getByteArray("data");
        if (offset == -1L) {
            try (OutputStream write = this.write(path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                write.write(dataBytes);
            }
        } else {
            this.fs.write(path, offset, dataBytes);
        }
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private @NotNull FileSystem.Response copyOrCut(FileSystem fileSystem, Level level, CompoundTag actionData) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        Path file = Path.of(actionData.getString("source"));
        if (!this.getFs().exists(file)) {
            return FileSystem.createResponse(2, "File not found on server. Please refresh!");
        }
        UUID uuid = UUID.fromString(actionData.getString("destination_drive"));
        AbstractDrive drive = fileSystem.getAvailableDrives(level, true).get(uuid);
        if (drive == null) {
            return FileSystem.createResponse(7, "Drive unavailable. Please refresh!");
        }
        Path destination = Path.of(actionData.getString("destination_folder"));
        if (!this.getFs().exists(destination)) {
            return FileSystem.createResponse(2, "Destination folder not found on server. Please refresh!");
        }
        for (Path temp = destination; temp != null; temp = temp.getParent()) {
            if (!temp.equals(file)) continue;
            return FileSystem.createResponse(0, "Destination folder can't be a subfolder");
        }
        try (InputStream read = this.read(file, StandardOpenOption.READ);){
            FileSystem.Response response;
            block20: {
                OutputStream write;
                block18: {
                    FileSystem.Response response2;
                    block19: {
                        this.createFile(destination, read.readAllBytes());
                        write = this.write(destination, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                        try {
                            byte[] bytes = read.readAllBytes();
                            write.write(bytes);
                            write.flush();
                            if (actionData.getBoolean("cut")) break block18;
                            response2 = FileSystem.createSuccessResponse();
                            if (write == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (write != null) {
                                try {
                                    write.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        write.close();
                    }
                    return response2;
                }
                this.getFs().delete(file);
                response = FileSystem.createSuccessResponse();
                if (write == null) break block20;
                write.close();
            }
            return response;
        }
    }

    public abstract CompoundTag toTag();

    public abstract Type getType();

    @Deprecated
    @Nullable
    public ServerFolder getFolder(String path) {
        this.setLastAccessed(System.currentTimeMillis());
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        return null;
    }

    @Deprecated
    public ServerFolder getDriveStructure() {
        this.setLastAccessed(System.currentTimeMillis());
        return null;
    }

    @Override
    public void close() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().close();
    }

    @Override
    public InputStream read(Path path, OpenOption ... options) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().read(path, options);
    }

    @Override
    public OutputStream write(Path path, OpenOption ... options) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().write(path, options);
    }

    @Override
    public boolean exists(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().exists(path);
    }

    @Override
    public void flush() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().flush();
    }

    @Override
    public void createFile(Path path, byte[] data) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().createFile(path, data);
    }

    @Override
    public void createDirectory(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().createDirectory(path);
    }

    @Override
    public Iterator<String> listDirectory(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().listDirectory(of);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().delete(path);
    }

    @Override
    public long size(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().size(path);
    }

    @Override
    public void rename(Path from, String name) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().rename(from, name);
    }

    @Override
    public boolean isFolder(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().isFolder(path);
    }

    @Override
    public boolean isFile(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().isFile(path);
    }

    @Override
    public boolean isSymbolicLink(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().isSymbolicLink(path);
    }

    public void setDamaged(boolean b) {
        this.setLastAccessed(System.currentTimeMillis());
        this.damaged = b;
    }

    public boolean isDamaged() {
        this.setLastAccessed(System.currentTimeMillis());
        return this.damaged;
    }

    @Override
    public boolean canRead(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().canRead(of);
    }

    @Override
    public boolean canWrite(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().canWrite(of);
    }

    @Override
    public void setReadOnly(Path of, boolean b) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().setReadOnly(of, b);
    }

    @Override
    public void setExecutable(Path of, boolean b) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.getFs().setExecutable(of, b);
    }

    @Override
    public boolean canExecute(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs().canExecute(of);
    }

    public Ext2FS getFS() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.getFs();
    }

    public Ext2FS getFs() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        if (this.deferred || this.fs == null) {
            this.deferred = false;
            if (this.fs != null) {
                return this.fs;
            }
            try {
                java.nio.file.Path resolve = UltreonDevices.getServer().getWorldPath(LevelResource.ROOT).resolve("data/devices/drives/" + String.valueOf(this.uuid) + ".ext2");
                if (Files.notExists(resolve, new LinkOption[0])) {
                    if (Files.notExists(resolve.getParent(), new LinkOption[0])) {
                        Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                    }
                    this.setFs(Ext2FS.format(resolve, 0x1000000L));
                    this.setup();
                } else {
                    this.setFs(Ext2FS.open(resolve));
                }
            }
            catch (IOException | FileSystemException e) {
                this.invalid = true;
                throw new IOException("Failed to open drive, vHardware failure. Device invalid!", e);
            }
        }
        if (this.invalid | this.damaged) {
            throw new IOException("Failed to open drive, vHardware failure. Previous error!");
        }
        if (this.fs == null) {
            throw new IOException("Failed to open drive, vHardware failure. Invalid filesystem!");
        }
        return this.fs;
    }

    public void setFs(Ext2FS fs) {
        this.setLastAccessed(System.currentTimeMillis());
        if (this.fs != null) {
            throw new IllegalStateException("Already set!");
        }
        if (fs == null) {
            throw new IllegalArgumentException("The filesystem can not be null");
        }
        this.fs = fs;
    }

    @Override
    @Nullable
    public LockKey lock(String path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.lock(path);
    }

    @Override
    public void unlock(String directory) {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.unlock(directory);
    }

    @Override
    public boolean isLocked(String directory) {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.isLocked(directory);
    }

    @Override
    public boolean isExecutable(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.isExecutable(of);
    }

    @Override
    public boolean isWritable(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.isWritable(of);
    }

    @Override
    public boolean isReadable(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.isReadable(of);
    }

    @Override
    public int getOwner(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getOwner(of);
    }

    @Override
    public int getGroup(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getGroup(of);
    }

    @Override
    public int getPermissions(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getPermissions(of);
    }

    @Override
    public void setPermissions(Path of, int mode) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setPermissions(of, mode);
    }

    @Override
    public void setOwner(Path of, int uid, int gid) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setOwner(of, uid, gid);
    }

    @Override
    public void setGroup(Path of, int gid) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setGroup(of, gid);
    }

    @Override
    public void setOwner(Path of, int uid) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setOwner(of, uid);
    }

    @Override
    public long getGeneration(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getGeneration(of);
    }

    @Override
    public void setGeneration(Path of, long generation) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setGeneration(of, generation);
    }

    @Override
    public boolean isReadOnly(Path of) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.isReadOnly(of);
    }

    @Override
    public long lastModified(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.lastModified(path);
    }

    @Override
    public long lastAccessed(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.lastAccessed(path);
    }

    @Override
    public long creationTime(Path path) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.creationTime(path);
    }

    @Override
    public void setLastAccessed(Path path, long time) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setLastAccessed(path, time);
    }

    @Override
    public void setLastModified(Path path, long time) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setLastModified(path, time);
    }

    @Override
    public void setCreationTime(Path path, long time) throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        this.fs.setCreationTime(path, time);
    }

    @Override
    public long getTotalSpace() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getUsableSpace();
    }

    @Override
    public long getFreeSpace() throws IOException {
        this.setLastAccessed(System.currentTimeMillis());
        return this.fs.getFreeSpace();
    }

    @Override
    public void move(Path source, Path destination) throws IOException {
        this.fs.move(source, destination);
        this.setLastAccessed(System.currentTimeMillis());
    }

    @Override
    public void copy(Path source, Path destination) throws IOException {
        this.fs.copy(source, destination);
        this.setLastAccessed(System.currentTimeMillis());
    }

    @Override
    public void write(Path path, long offset, byte[] dataBytes) throws IOException {
        this.fs.write(path, offset, dataBytes);
        this.setLastAccessed(System.currentTimeMillis());
    }

    @Override
    public void write(Path path, byte[] dataBytes) throws IOException {
        this.fs.write(path, dataBytes);
        this.setLastAccessed(System.currentTimeMillis());
    }

    @Override
    public void truncate(Path path, long size) throws IOException {
        this.fs.truncate(path, size);
        this.setLastAccessed(System.currentTimeMillis());
    }

    @Override
    public void read(Path path, ByteBuffer buffer, long offset) throws IOException {
        this.fs.read(path, buffer, offset);
        this.setLastAccessed(System.currentTimeMillis());
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
        DriveManager.updateLastAccessed(this.uuid, lastAccessed);
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK;

    }
}

