/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.drive;

import dev.ultreon.devices.core.io.drive.AbstractDrive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jnode.fs.FileSystemException;

public final class ExternalDrive
extends AbstractDrive {
    private static final Predicate<CompoundTag> PREDICATE_DRIVE_TAG = tag -> tag.contains("name", 8) && tag.contains("uuid", 8) && tag.contains("root", 10);

    private ExternalDrive() {
    }

    public ExternalDrive(String displayName) {
        super(displayName);
    }

    private ExternalDrive(UUID uuid, Path drivePath) throws FileSystemException, IOException {
        super(uuid, drivePath);
    }

    private ExternalDrive(String s, UUID uuid) {
        super(s);
        this.uuid = uuid;
    }

    public static ExternalDrive load(UUID uuid, Path drivePath) {
        try {
            return new ExternalDrive(uuid, drivePath);
        }
        catch (IOException | FileSystemException e) {
            return null;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static ExternalDrive fromTag(CompoundTag driveTag) {
        return new ExternalDrive(driveTag.contains("name") ? driveTag.getString("name") : "Drive", UUID.fromString(driveTag.getString("uuid")));
    }

    @Override
    @ApiStatus.Internal
    public CompoundTag toTag() {
        CompoundTag driveTag = new CompoundTag();
        driveTag.putString("name", this.name);
        driveTag.putString("uuid", this.uuid.toString());
        return driveTag;
    }

    @Override
    public AbstractDrive.Type getType() {
        return AbstractDrive.Type.EXTERNAL;
    }
}

