/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.drive;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.DriveManager;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jnode.fs.FileSystemException;

public final class InternalDrive
extends AbstractDrive {
    public InternalDrive(String name) {
        super(name);
        DriveManager.registerInternalDrive(this);
    }

    public InternalDrive(String name, UUID uuid) {
        super(uuid);
        DriveManager.registerInternalDrive(this);
    }

    @Override
    protected void setup() {
        super.setup();
        try {
            this.createDirectory(Path.of("/Home"));
            this.createDirectory(Path.of("/ApplicationData"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InternalDrive(UUID uuid, java.nio.file.Path drivePath) throws FileSystemException, IOException {
        super(uuid, drivePath);
    }

    @ApiStatus.Internal
    @NotNull
    public static AbstractDrive fromTag(CompoundTag driveTag) {
        String string = driveTag.toString();
        System.out.println("string = " + string);
        if (!driveTag.contains("uuid")) {
            if (!driveTag.contains("name")) {
                return new InternalDrive("Drive");
            }
            return new InternalDrive(driveTag.getString("name"));
        }
        if (!driveTag.contains("name")) {
            return new InternalDrive("Drive", NbtUtils.loadUUID((Tag)driveTag.getCompound("uuid")));
        }
        try {
            Tag uuid1 = driveTag.get("uuid");
            if (!(uuid1 instanceof IntArrayTag)) {
                UltreonDevices.LOGGER.warn("Invalid uuid tag in drive tag: {}", (Object)uuid1);
                return new InternalDrive(driveTag.contains("name") ? driveTag.getString("name") : "Drive");
            }
            UUID uuid2 = NbtUtils.loadUUID((Tag)uuid1);
            return DriveManager.getInternalDrive(uuid2);
        }
        catch (Exception e) {
            return new InternalDrive("Drive");
        }
    }

    @Deprecated
    public static InternalDrive load(UUID uuid, java.nio.file.Path drivePath) {
        try {
            return new InternalDrive(uuid, drivePath);
        }
        catch (IOException | FileSystemException e) {
            return null;
        }
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag driveTag = new CompoundTag();
        driveTag.putString("name", this.name);
        driveTag.put("uuid", (Tag)NbtUtils.createUUID((UUID)this.uuid));
        return driveTag;
    }

    @Override
    public AbstractDrive.Type getType() {
        return AbstractDrive.Type.INTERNAL;
    }
}

