/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.task;

import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TaskGetMainDrive
extends Task {
    private BlockPos pos;
    private AbstractDrive mainDrive;

    public TaskGetMainDrive() {
    }

    public TaskGetMainDrive(BlockPos pos) {
        this();
        this.pos = pos;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putLong("pos", this.pos.asLong());
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        BlockEntity tileEntity = level.getBlockEntity(BlockPos.of((long)tag.getLong("pos")));
        if (tileEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity laptop = (ComputerBlockEntity)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            this.mainDrive = fileSystem.getMainDrive();
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.isSuccessful()) {
            CompoundTag mainDriveTag = new CompoundTag();
            mainDriveTag.putString("name", this.mainDrive.getName());
            mainDriveTag.put("uuid", (Tag)NbtUtils.createUUID((UUID)this.mainDrive.getUuid()));
            mainDriveTag.putString("type", this.mainDrive.getType().toString());
            tag.put("main_drive", (Tag)mainDriveTag);
        }
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.isSuccessful() && Minecraft.getInstance().screen instanceof ComputerScreen) {
            Drive drive = new Drive(tag.getCompound("main_drive"));
            if (ComputerScreen.getMainDrive() == null) {
                ComputerScreen.setMainDrive(drive);
            }
        }
    }
}

