/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.action.FileAction;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskSendAction
extends Task {
    private UUID uuid;
    private FileAction<?> action;
    private BlockPos pos;
    private FileSystem.Response response;

    public TaskSendAction() {
    }

    public TaskSendAction(UUID drive, FileAction<?> action) {
        this();
        this.uuid = drive;
        this.action = action;
        this.pos = ComputerScreen.getPos();
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putUUID("uuid", this.uuid);
        tag.put("action", (Tag)this.action.toTag());
        tag.putLong("pos", this.pos.asLong());
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        FileAction<?> action = FileAction.fromTag(tag.getCompound("action"));
        BlockEntity tileEntity = level.getChunkAt(BlockPos.of((long)tag.getLong("pos"))).getBlockEntity(BlockPos.of((long)tag.getLong("pos")), LevelChunk.EntityCreationType.IMMEDIATE);
        if (tileEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity laptop = (ComputerBlockEntity)tileEntity;
            this.response = laptop.getFileSystem().readAction(tag.getUUID("uuid"), action, level);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
        tag.put("response", (Tag)this.response.toTag());
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

