/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.task;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.debug.DebugLog;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskSetupFileBrowser
extends Task {
    private BlockPos pos;
    private boolean includeMain;
    private AbstractDrive mainDrive;
    private Map<UUID, AbstractDrive> availableDrives;

    public TaskSetupFileBrowser() {
    }

    public TaskSetupFileBrowser(BlockPos pos, boolean includeMain) {
        this();
        this.pos = pos;
        this.includeMain = includeMain;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putLong("pos", this.pos.asLong());
        tag.putBoolean("include_main", this.includeMain);
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        BlockEntity tileEntity = level.getChunkAt(BlockPos.of((long)tag.getLong("pos"))).getBlockEntity(BlockPos.of((long)tag.getLong("pos")), LevelChunk.EntityCreationType.IMMEDIATE);
        if (tileEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity laptop = (ComputerBlockEntity)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            if (tag.getBoolean("include_main")) {
                this.mainDrive = fileSystem.getMainDrive();
            }
            this.availableDrives = fileSystem.getAvailableDrives(level, false);
            this.setSuccessful();
        } else {
            UltreonDevices.LOGGER.warn("BlockEntity at pos " + String.valueOf(BlockPos.of((long)tag.getLong("pos"))) + " is not a ComputerBlockEntity");
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.isSuccessful()) {
            if (this.mainDrive != null) {
                CompoundTag mainDriveTag = new CompoundTag();
                mainDriveTag.putString("name", this.mainDrive.getName());
                mainDriveTag.putUUID("uuid", this.mainDrive.getUuid());
                mainDriveTag.putString("type", this.mainDrive.getType().toString());
                tag.put("main_drive", (Tag)mainDriveTag);
            }
            ListTag driveList = new ListTag();
            this.availableDrives.forEach((k, v) -> {
                DebugLog.log("k = " + String.valueOf(k));
                DebugLog.log("v.getUuid() = " + String.valueOf(v.getUuid()));
                CompoundTag driveTag = new CompoundTag();
                driveTag.putString("name", v.getName());
                driveTag.putUUID("uuid", v.getUuid());
                driveTag.putString("type", v.getType().toString());
                driveList.add((Object)driveTag);
            });
            tag.put("available_drives", (Tag)driveList);
        }
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

