/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.laptop.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.laptop.client.ClientLaptop;
import dev.ultreon.devices.debug.DebugLog;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ClientLaptopScreen
extends Screen {
    static final ResourceLocation LAPTOP_GUI = UltreonDevices.res("textures/gui/laptop.png");
    private static final int BORDER = 10;
    private final ClientLaptop laptop;

    public ClientLaptopScreen(ClientLaptop laptop) {
        super((Component)Component.translatable((String)laptop.toString()));
        this.laptop = laptop;
    }

    public void renderBezels(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LAPTOP_GUI);
        int posX = (this.width - 384) / 2;
        int posY = (this.height - 216) / 2;
        graphics.blit(LAPTOP_GUI, posX, posY, 0, 0, 10, 10);
        graphics.blit(LAPTOP_GUI, posX + 384 - 10, posY, 11, 0, 10, 10);
        graphics.blit(LAPTOP_GUI, posX + 384 - 10, posY + 216 - 10, 11, 11, 10, 10);
        graphics.blit(LAPTOP_GUI, posX, posY + 216 - 10, 0, 11, 10, 10);
        graphics.blit(LAPTOP_GUI, posX + 10, posY, 364, 10, 10.0f, 0.0f, 1, 10, 256, 256);
        graphics.blit(LAPTOP_GUI, posX + 384 - 10, posY + 10, 10, 196, 11.0f, 10.0f, 10, 1, 256, 256);
        graphics.blit(LAPTOP_GUI, posX + 10, posY + 216 - 10, 364, 10, 10.0f, 11.0f, 1, 10, 256, 256);
        graphics.blit(LAPTOP_GUI, posX, posY + 10, 10, 196, 0.0f, 11.0f, 10, 1, 256, 256);
        graphics.blit(LAPTOP_GUI, posX + 10, posY + 10, 364, 196, 10.0f, 10.0f, 1, 1, 256, 256);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int posX = (this.width - 384) / 2 + 10;
        int posY = (this.height - 216) / 2 + 10;
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderBezels(graphics, mouseX, mouseY, partialTick);
        graphics.pose().translate((float)posX, (float)posY, 0.0f);
        this.laptop.render(graphics, mouseX - posX, mouseY - posY, partialTick);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        int posX = (this.width - 384) / 2 + 10;
        int posY = (this.height - 216) / 2 + 10;
        super.mouseMoved(mouseX, mouseY);
        this.laptop.mouseMoved(mouseX - (double)posX, mouseY - (double)posY);
        DebugLog.log(Arrays.toString(this.laptop.square));
    }
}

