/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.Router;
import dev.ultreon.devices.debug.DebugLog;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Connection {
    private UUID routerId;
    private BlockPos routerPos;

    private Connection() {
    }

    public Connection(Router router) {
        this.routerId = router.getId();
        this.routerPos = router.getPos();
    }

    public UUID getRouterId() {
        return this.routerId;
    }

    @Nullable
    public BlockPos getRouterPos() {
        return this.routerPos;
    }

    public void setRouterPos(@Nullable BlockPos routerPos) {
        this.routerPos = routerPos;
    }

    @Nullable
    public Router getRouter(@NotNull Level level) {
        if (this.routerPos == null) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.routerPos);
        System.out.println("routerPos = " + String.valueOf(this.routerPos));
        System.out.println("blockEntity = " + String.valueOf(blockEntity));
        if (blockEntity instanceof RouterBlockEntity) {
            RouterBlockEntity router = (RouterBlockEntity)blockEntity;
            if (router.getRouter().getId().equals(this.routerId)) {
                return router.getRouter();
            }
            DebugLog.log("Invalid router ID");
        } else {
            DebugLog.log("Router is not a router");
        }
        return null;
    }

    public boolean isConnected() {
        return this.routerPos != null;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", this.routerId.toString());
        if (this.routerPos != null) {
            tag.put("Pos", NbtUtils.writeBlockPos((BlockPos)this.routerPos));
        }
        return tag;
    }

    public static Connection fromTag(CompoundTag tag) {
        Connection connection = new Connection();
        connection.routerId = UUID.fromString(tag.getString("id"));
        if (tag.contains("Pos", 10)) {
            Optional pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"Pos");
            if (pos.isEmpty()) {
                UltreonDevices.LOGGER.warn("Failed to read block position from connection tag!");
                connection.routerPos = null;
            } else {
                connection.routerPos = (BlockPos)pos.get();
            }
        }
        return connection;
    }
}

