/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network;

import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.core.Device;
import dev.ultreon.devices.core.network.Router;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkDevice
extends Device {
    private NetworkDevice() {
    }

    public NetworkDevice(NetworkDeviceBlockEntity device) {
        super(device);
    }

    public NetworkDevice(@NotNull UUID id, @NotNull String name, @NotNull Router router) {
        super(id, name);
    }

    public boolean isConnected(Level level) {
        if (this.pos == null) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
            Router router = device.getRouter();
            return router != null && router.getId().equals(this.getId());
        }
        return false;
    }

    @Override
    @Nullable
    public NetworkDeviceBlockEntity getDevice(@NotNull Level level) {
        if (this.pos == null) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
            return device;
        }
        return null;
    }

    @Override
    public CompoundTag toTag(boolean includePos) {
        CompoundTag tag = super.toTag(includePos);
        if (includePos && this.pos != null) {
            tag.putLong("pos", this.pos.asLong());
        }
        return tag;
    }

    public static NetworkDevice fromTag(CompoundTag tag) {
        NetworkDevice device = new NetworkDevice();
        device.id = UUID.fromString(tag.getString("id"));
        device.name = tag.getString("name");
        if (tag.contains("pos", 4)) {
            device.pos = BlockPos.of((long)tag.getLong("pos"));
        }
        return device;
    }
}

