/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.api.event.RouterBeaconEvent;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.DeviceConnectEvent;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class Router {
    private final Map<UUID, NetworkDevice> networkDevices = new HashMap<UUID, NetworkDevice>();
    private int timer;
    private UUID routerId;
    private BlockPos pos;

    public Router(BlockPos pos) {
        this.pos = pos;
    }

    public void tick(RouterBlockEntity blockEntity, Level level) {
        if (++this.timer >= (Integer)DeviceConfig.BEACON_INTERVAL.get()) {
            this.sendBeacon(blockEntity, level);
            this.timer = 0;
        }
    }

    public boolean addDevice(UUID id, String name) {
        NetworkDevice networkDevice;
        if (this.networkDevices.size() >= (Integer)DeviceConfig.MAX_DEVICES.get()) {
            return this.networkDevices.containsKey(id);
        }
        if (!this.networkDevices.containsKey(id) && !((DeviceConnectEvent)EventSystem.MAIN.publish((Object)new DeviceConnectEvent(this, networkDevice = new NetworkDevice(id, name, this)))).isCanceled()) {
            this.networkDevices.put(id, networkDevice);
        }
        this.timer = (Integer)DeviceConfig.BEACON_INTERVAL.get();
        return true;
    }

    public boolean addDevice(NetworkDeviceBlockEntity device) {
        NetworkDevice networkDevice;
        if (this.networkDevices.size() >= (Integer)DeviceConfig.MAX_DEVICES.get()) {
            return this.networkDevices.containsKey(device.getId());
        }
        if (!this.networkDevices.containsKey(device.getId()) && !((DeviceConnectEvent)EventSystem.MAIN.publish((Object)new DeviceConnectEvent(this, networkDevice = new NetworkDevice(device)))).isCanceled()) {
            this.networkDevices.put(device.getId(), networkDevice);
        }
        return true;
    }

    public boolean isDeviceRegistered(NetworkDeviceBlockEntity device) {
        return this.networkDevices.containsKey(device.getId());
    }

    public boolean isDeviceConnected(NetworkDeviceBlockEntity device) {
        return this.isDeviceRegistered(device) && this.networkDevices.get(device.getId()).getPos() != null;
    }

    public void removeDevice(NetworkDeviceBlockEntity device) {
        this.networkDevices.remove(device.getId());
    }

    @Nullable
    public NetworkDeviceBlockEntity getDevice(Level level, UUID id) {
        return this.networkDevices.containsKey(id) ? this.networkDevices.get(id).getDevice(level) : null;
    }

    public Collection<NetworkDevice> getNetworkDevices() {
        return this.networkDevices.values();
    }

    public Collection<NetworkDevice> getConnectedDevices(Level level) {
        Optional blockEntity = level.getBlockEntity(this.pos, (BlockEntityType)DeviceBlockEntities.ROUTER.get());
        if (blockEntity.isEmpty()) {
            return Collections.emptyList();
        }
        this.sendBeacon((RouterBlockEntity)blockEntity.get(), level);
        return this.networkDevices.values().stream().filter(device -> device.getPos() != null).toList();
    }

    public Collection<NetworkDevice> getConnectedDevices(Level level, BlockEntityType<?> targetType) {
        Predicate<NetworkDevice> deviceType = networkDevice -> {
            NetworkDeviceBlockEntity device;
            if (networkDevice.getPos() == null) {
                return false;
            }
            BlockEntity blockEntity = level.getBlockEntity(networkDevice.getPos());
            return blockEntity instanceof NetworkDeviceBlockEntity && targetType.equals((device = (NetworkDeviceBlockEntity)blockEntity).getType());
        };
        return this.getConnectedDevices(level).stream().filter(deviceType).toList();
    }

    public Collection<NetworkDevice> getConnectedDevices(Level level, TagKey<BlockEntityType<?>> targetType) {
        Predicate<NetworkDevice> deviceType = networkDevice -> {
            if (networkDevice.getPos() == null) {
                return false;
            }
            BlockEntity blockEntity = level.getBlockEntity(networkDevice.getPos());
            if (blockEntity instanceof NetworkDeviceBlockEntity) {
                NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
                return BuiltInRegistries.BLOCK_ENTITY_TYPE.wrapAsHolder((Object)blockEntity.getType()).is(targetType);
            }
            return false;
        };
        return this.getConnectedDevices(level).stream().filter(deviceType).toList();
    }

    private void sendBeacon(RouterBlockEntity blockEntity, Level level) {
        if (level.isClientSide) {
            return;
        }
        EventSystem.MAIN.publish((Object)new RouterBeaconEvent(this, blockEntity, this.networkDevices));
        this.networkDevices.forEach((uuid, device) -> device.setPos(null));
        int range = (Integer)DeviceConfig.SIGNAL_RANGE.get();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    this.sendBeaconAt(level, x, y, z);
                }
            }
        }
    }

    private void sendBeaconAt(Level level, int x, int y, int z) {
        BlockPos currentPos = new BlockPos(this.pos.getX() + x, this.pos.getY() + y, this.pos.getZ() + z);
        BlockEntity blockEntity = level.getBlockEntity(currentPos);
        if (blockEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
            if (!this.networkDevices.containsKey(device.getId())) {
                return;
            }
            if (device.receiveBeacon(this)) {
                this.networkDevices.get(device.getId()).setPos(currentPos);
            }
        }
    }

    public UUID getId() {
        if (this.routerId == null) {
            this.routerId = UUID.randomUUID();
        }
        return this.routerId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public CompoundTag toTag(boolean includePos) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("id", this.getId());
        ListTag deviceList = new ListTag();
        this.networkDevices.forEach((id, device) -> deviceList.add((Object)device.toTag(includePos)));
        tag.put("network_devices", (Tag)deviceList);
        return tag;
    }

    public static Router fromTag(BlockPos pos, CompoundTag tag) {
        Router router = new Router(pos);
        router.routerId = tag.getUUID("id");
        ListTag deviceList = tag.getList("network_devices", 10);
        for (int i = 0; i < deviceList.size(); ++i) {
            NetworkDevice device = NetworkDevice.fromTag(deviceList.getCompound(i));
            router.networkDevices.put(device.getId(), device);
        }
        return router;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Router)) {
            return false;
        }
        Router router = (Router)o;
        return Objects.equals(this.routerId, router.routerId);
    }

    public int hashCode() {
        return Objects.hash(this.routerId);
    }
}

