/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.block.entity.DeviceBlockEntity;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Device;
import dev.ultreon.devices.core.network.task.TaskConnect;
import dev.ultreon.devices.core.network.task.TaskPing;
import dev.ultreon.devices.object.TrayItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.EnumUtils;

public class TrayItemWifi
extends TrayItem {
    private int pingTimer;
    private Strength strength = Strength.NONE;

    public TrayItemWifi() {
        super(Icons.WIFI_NONE, UltreonDevices.res("wifi"));
    }

    private static Layout createWifiMenu(TrayItem item) {
        Layout.Context layout = new Layout.Context(100, 100);
        layout.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> graphics.fill(x, y, x + width, y + height, new Color(0.65f, 0.65f, 0.65f, 0.9f).getRGB()));
        ItemList<Device> itemListRouters = new ItemList<Device>(5, 5, 90, 4);
        itemListRouters.setItems(TrayItemWifi.getRouters());
        itemListRouters.setListItemRenderer(new ListItemRenderer<Device>(16){

            @Override
            public void render(GuiGraphics graphics, Device device, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                graphics.fill(x, y, x + width, y + height, selected ? Color.DARK_GRAY.getRGB() : Color.GRAY.getRGB());
                RenderUtil.drawStringClipped(graphics, device.getName(), x + 16, y + 4, 70, Color.WHITE.getRGB(), false);
                if (device.getPos() == null) {
                    return;
                }
                BlockPos laptopPos = ComputerScreen.getPos();
                assert (laptopPos != null);
                double distance = Math.sqrt(device.getPos().distToCenterSqr((double)laptopPos.getX() + 0.5, (double)laptopPos.getY() + 0.5, (double)laptopPos.getZ() + 0.5));
                if (distance > 20.0) {
                    Icons.WIFI_LOW.draw(graphics, mc, x + 3, y + 3);
                } else if (distance > 10.0) {
                    Icons.WIFI_MED.draw(graphics, mc, x + 3, y + 3);
                } else {
                    Icons.WIFI_HIGH.draw(graphics, mc, x + 3, y + 3);
                }
            }
        });
        itemListRouters.sortBy((o1, o2) -> {
            BlockPos laptopPos = ComputerScreen.getPos();
            assert (o1.getPos() != null);
            assert (laptopPos != null);
            double distance1 = Math.sqrt(o1.getPos().distToCenterSqr((double)laptopPos.getX() + 0.5, (double)laptopPos.getY() + 0.5, (double)laptopPos.getZ() + 0.5));
            assert (o2.getPos() != null);
            double distance2 = Math.sqrt(o2.getPos().distToCenterSqr((double)laptopPos.getX() + 0.5, (double)laptopPos.getY() + 0.5, (double)laptopPos.getZ() + 0.5));
            return Double.compare(distance1, distance2);
        });
        layout.addComponent(itemListRouters);
        Button buttonConnect = new Button(79, 79, Icons.CHECK);
        buttonConnect.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && itemListRouters.getSelectedItem() != null) {
                TaskConnect connect = new TaskConnect(ComputerScreen.getPos(), ((Device)itemListRouters.getSelectedItem()).getPos());
                connect.setCallback((tag, success) -> {
                    if (success) {
                        item.setIcon(Icons.WIFI_HIGH);
                        ComputerScreen.getSystem().closeContext();
                    }
                });
                TaskManager.sendTask(connect);
            }
        });
        layout.addComponent(buttonConnect);
        return layout;
    }

    private static List<Device> getRouters() {
        ArrayList<Device> routers = new ArrayList<Device>();
        ClientLevel level = Minecraft.getInstance().level;
        if (ComputerScreen.isWorldLess()) {
            return new ArrayList<Device>();
        }
        BlockPos laptopPos = ComputerScreen.getPos();
        int range = (Integer)DeviceConfig.SIGNAL_RANGE.get();
        for (int y = -range; y < range + 1; ++y) {
            for (int z = -range; z < range + 1; ++z) {
                for (int x = -range; x < range + 1; ++x) {
                    assert (laptopPos != null);
                    BlockPos pos = new BlockPos(laptopPos.getX() + x, laptopPos.getY() + y, laptopPos.getZ() + z);
                    assert (level != null);
                    BlockEntity tileEntity = level.getBlockEntity(pos);
                    if (!(tileEntity instanceof RouterBlockEntity)) continue;
                    routers.add(new Device((DeviceBlockEntity)tileEntity));
                }
            }
        }
        return routers;
    }

    @Override
    public void init() {
        this.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (ComputerScreen.getSystem().hasContext()) {
                ComputerScreen.getSystem().closeContext();
            } else {
                ComputerScreen.getSystem().openContext(TrayItemWifi.createWifiMenu(this), mouseX - 100, mouseY - 100);
            }
        });
        this.runPingTask();
    }

    @Override
    public void tick() {
        if (++this.pingTimer >= (Integer)DeviceConfig.PING_RATE.get()) {
            this.runPingTask();
            this.pingTimer = 0;
        }
    }

    private void runPingTask() {
        TaskPing task = new TaskPing(ComputerScreen.getPos());
        task.setCallback((tag, success) -> {
            if (success) {
                assert (tag != null);
                int strength = tag.getInt("strength");
                switch (strength) {
                    case 2: {
                        this.strength = Strength.LOW;
                        this.setIcon(Icons.WIFI_LOW);
                        break;
                    }
                    case 1: {
                        this.strength = Strength.MED;
                        this.setIcon(Icons.WIFI_MED);
                        break;
                    }
                    case 0: {
                        this.strength = Strength.HIGH;
                        this.setIcon(Icons.WIFI_HIGH);
                        break;
                    }
                    default: {
                        this.strength = Strength.NONE;
                        this.setIcon(Icons.WIFI_NONE);
                        break;
                    }
                }
            } else {
                this.setIcon(Icons.WIFI_NONE);
            }
        });
        TaskManager.sendTask(task);
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.pingTimer = tag.getInt("pingTimer");
        this.strength = (Strength)EnumUtils.getEnum(Strength.class, (String)tag.getString("strength"), (Enum)Strength.NONE);
        switch (this.strength.ordinal()) {
            case 0: {
                this.setIcon(Icons.WIFI_LOW);
                break;
            }
            case 1: {
                this.setIcon(Icons.WIFI_MED);
                break;
            }
            case 2: {
                this.setIcon(Icons.WIFI_HIGH);
                break;
            }
            case 3: {
                this.setIcon(Icons.WIFI_NONE);
            }
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.putInt("pingTimer", this.pingTimer);
        tag.putString("strength", this.strength.name());
        return tag;
    }

    public static enum Strength {
        LOW,
        MED,
        HIGH,
        NONE;

    }
}

