/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.Router;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskConnect
extends Task {
    private BlockPos devicePos;
    private BlockPos routerPos;

    public TaskConnect() {
    }

    public TaskConnect(BlockPos devicePos, BlockPos routerPos) {
        this();
        this.devicePos = devicePos;
        this.routerPos = routerPos;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putLong("devicePos", this.devicePos.asLong());
        tag.putLong("routerPos", this.routerPos.asLong());
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        BlockEntity tileEntity = level.getChunkAt(BlockPos.of((long)tag.getLong("routerPos"))).getBlockEntity(BlockPos.of((long)tag.getLong("routerPos")), LevelChunk.EntityCreationType.IMMEDIATE);
        if (tileEntity instanceof RouterBlockEntity) {
            NetworkDeviceBlockEntity tileEntityNetworkDevice;
            RouterBlockEntity tileEntityRouter = (RouterBlockEntity)tileEntity;
            Router router = tileEntityRouter.getRouter();
            BlockEntity tileEntity1 = level.getChunkAt(BlockPos.of((long)tag.getLong("devicePos"))).getBlockEntity(BlockPos.of((long)tag.getLong("devicePos")), LevelChunk.EntityCreationType.IMMEDIATE);
            if (tileEntity1 instanceof NetworkDeviceBlockEntity && router.addDevice(tileEntityNetworkDevice = (NetworkDeviceBlockEntity)tileEntity1)) {
                tileEntityNetworkDevice.connect(router);
                this.setSuccessful();
            }
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

