/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.core.network.Router;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskGetDevices
extends Task {
    private BlockPos devicePos;
    private BlockEntityType<?> targetType;
    private Collection<NetworkDevice> foundDevices;
    private String reason;

    public TaskGetDevices() {
    }

    public TaskGetDevices(BlockPos devicePos) {
        this();
        this.devicePos = devicePos;
    }

    public TaskGetDevices(BlockPos devicePos, BlockEntityType<?> targetType) {
        this();
        this.devicePos = devicePos;
        this.targetType = targetType;
    }

    @Deprecated(forRemoval=true)
    public TaskGetDevices(BlockPos devicePos, Class<? extends NetworkDeviceBlockEntity> ignoredTargetDeviceClass) {
        this();
        this.devicePos = devicePos;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putLong("devicePos", this.devicePos.asLong());
        if (this.targetType != null) {
            tag.putInt("targetType", BuiltInRegistries.BLOCK_ENTITY_TYPE.getId(this.targetType));
        }
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        BlockPos devicePos = BlockPos.of((long)tag.getLong("devicePos"));
        int typeId = tag.getInt("targetType");
        if (typeId < 0) {
            this.reason = "Invalid target ID received: " + typeId;
            return;
        }
        BlockEntityType targetType = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.byId(typeId);
        BlockEntity tileEntity = level.getChunkAt(devicePos).getBlockEntity(devicePos, LevelChunk.EntityCreationType.IMMEDIATE);
        if (!(tileEntity instanceof NetworkDeviceBlockEntity)) {
            this.reason = "Not a network device";
            return;
        }
        NetworkDeviceBlockEntity tileEntityNetworkDevice = (NetworkDeviceBlockEntity)tileEntity;
        if (!tileEntityNetworkDevice.isConnected()) {
            this.reason = "Not connected to router";
            return;
        }
        Router router = tileEntityNetworkDevice.getRouter();
        if (router == null) {
            this.reason = "No internet access";
            return;
        }
        this.foundDevices = targetType != null ? router.getConnectedDevices(level) : router.getConnectedDevices(level, targetType);
        this.setSuccessful();
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.isSuccessful()) {
            ListTag deviceList = new ListTag();
            this.foundDevices.forEach(device -> deviceList.add((Object)device.toTag(true)));
            tag.put("network_devices", (Tag)deviceList);
        } else {
            tag.putString("reason", this.reason);
        }
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

