/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskPing
extends Task {
    private BlockPos sourceDevicePos;
    private int strength;

    public TaskPing() {
    }

    public TaskPing(BlockPos sourceDevicePos) {
        this();
        this.sourceDevicePos = sourceDevicePos;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putLong("sourceDevicePos", this.sourceDevicePos.asLong());
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        NetworkDeviceBlockEntity networkDevice;
        BlockEntity blockEntity = level.getChunkAt(BlockPos.of((long)tag.getLong("sourceDevicePos"))).getBlockEntity(BlockPos.of((long)tag.getLong("sourceDevicePos")), LevelChunk.EntityCreationType.IMMEDIATE);
        if (blockEntity instanceof NetworkDeviceBlockEntity && (networkDevice = (NetworkDeviceBlockEntity)blockEntity).isConnected()) {
            this.strength = networkDevice.getSignalStrength();
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.isSuccessful()) {
            tag.putInt("strength", this.strength);
        }
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

