/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.print.task;

import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.PrinterBlockEntity;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.core.network.Router;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskPrint
extends Task {
    private BlockPos devicePos;
    private UUID printerId;
    private IPrint print;
    private String reason = null;

    public TaskPrint() {
    }

    public TaskPrint(BlockPos devicePos, NetworkDevice printer, IPrint print) {
        this();
        this.devicePos = devicePos;
        this.printerId = printer.getId();
        this.print = print;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putLong("devicePos", this.devicePos.asLong());
        tag.putUUID("printerId", this.printerId);
        tag.put("print", (Tag)IPrint.save(this.print));
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        BlockEntity tileEntity = level.getChunkAt(BlockPos.of((long)tag.getLong("devicePos"))).getBlockEntity(BlockPos.of((long)tag.getLong("devicePos")), LevelChunk.EntityCreationType.IMMEDIATE);
        if (tileEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)tileEntity;
            Router router = device.getRouter();
            if (router != null) {
                NetworkDeviceBlockEntity printer = router.getDevice(level, tag.getUUID("printerId"));
                if (printer instanceof PrinterBlockEntity) {
                    IPrint print = IPrint.load(tag.getCompound("print"));
                    ((PrinterBlockEntity)printer).addToQueue(print);
                    this.setSuccessful();
                } else {
                    this.reason = "Network device is not a printer";
                }
            } else {
                this.reason = "Not connected to router";
            }
        } else {
            this.reason = "No network driver found";
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.reason != null) {
            tag.putString("reason", this.reason);
        }
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

