/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.task;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.object.AppInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class TaskInstallApp
extends Task {
    private String appId;
    private BlockPos laptopPos;
    private boolean install;

    public TaskInstallApp() {
    }

    public TaskInstallApp(AppInfo info, BlockPos laptopPos, boolean install) {
        this();
        this.appId = info.getFormattedId();
        this.laptopPos = laptopPos;
        this.install = install;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putString("appId", this.appId);
        tag.putLong("pos", this.laptopPos.asLong());
        tag.putBoolean("install", this.install);
        DebugLog.log("Prep message " + this.appId + ", " + this.laptopPos.toString() + ", " + this.install);
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag tag, Level level, Player player) {
        DebugLog.log("Proc message " + tag.getString("appId") + ", " + String.valueOf(BlockPos.of((long)tag.getLong("pos"))) + ", " + tag.getBoolean("install"));
        String appId = tag.getString("appId");
        DebugLog.log(level.getBlockState(BlockPos.of((long)tag.getLong("pos"))).getBlock());
        BlockEntity tileEntity = level.getChunkAt(BlockPos.of((long)tag.getLong("pos"))).getBlockEntity(BlockPos.of((long)tag.getLong("pos")), LevelChunk.EntityCreationType.IMMEDIATE);
        DebugLog.log(tileEntity);
        if (tileEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity laptop = (ComputerBlockEntity)tileEntity;
            CompoundTag systemData = laptop.getSystemData();
            ListTag list = systemData.getList("InstalledApps", 8);
            if (tag.getBoolean("install")) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.getString(i).equals(appId)) continue;
                    UltreonDevices.LOGGER.warn("Found duplicate, noping out");
                    return;
                }
                list.add((Object)StringTag.valueOf((String)appId));
                this.setSuccessful();
            } else {
                list.removeIf(appTag -> {
                    if (appTag.getAsString().equals(appId)) {
                        this.setSuccessful();
                        return true;
                    }
                    return false;
                });
            }
            systemData.put("InstalledApps", (Tag)list);
        }
        if (!this.isSuccessful()) {
            UltreonDevices.LOGGER.info("Installing {} unsuccessful", (Object)appId);
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag tag) {
    }
}

