/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.debug;

import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugLog {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Devices : Debugger");

    public static void log(String message) {
        if (XinexPlatform.isDevelopmentEnvironment()) {
            LOGGER.info(message);
        }
    }

    public static void log(Object ... message) {
        DebugLog.log(String.join((CharSequence)" ", Arrays.stream(message).map(Objects::toString).toList()));
    }

    public static void logTime(long ticks, String message) {
        if (XinexPlatform.isDevelopmentEnvironment()) {
            LOGGER.info("(@{} ticks) {}", (Object)ticks, (Object)message);
        }
    }
}

