/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.entity;

import dev.ultreon.devices.init.DeviceEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class Seat
extends Entity {
    private double yOffset;
    private BlockPos blockPos;

    public Seat(EntityType<? extends Seat> type, Level worldIn) {
        super(type, worldIn);
        this.setBoundingBox(new AABB((double)0.001f, (double)0.001f, (double)0.001f, (double)-0.001f, (double)-0.001f, (double)-0.001f));
        this.setInvisible(true);
    }

    public Seat(Level worldIn, BlockPos pos, double yOffset) {
        this((EntityType<? extends Seat>)((EntityType)DeviceEntities.SEAT.get()), worldIn);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + yOffset, (double)pos.getZ() + 0.5);
        this.blockPos = pos;
    }

    public double getEyeY() {
        return 0.0;
    }

    public void setYOffset(double offset) {
        this.yOffset = offset;
    }

    public void setViaYOffset(BlockPos pos) {
        this.blockPos = pos;
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + this.yOffset, (double)pos.getZ() + 0.5);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (!(this.level().isClientSide || this.blockPos != null && this.hasExactlyOnePlayerPassenger() && !this.level().isEmptyBlock(this.blockPos))) {
            this.kill();
        }
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Object e;
        List list = this.getPassengers();
        return list.isEmpty() ? null : ((e = list.getFirst()) instanceof LivingEntity ? (livingEntity = (LivingEntity)e) : null);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("DevicesChairX", 3) && compound.contains("DevicesChairY", 3) && compound.contains("DevicesChairZ", 3)) {
            this.blockPos = new BlockPos(compound.getInt("DevicesChairX"), compound.getInt("DevicesChairY"), compound.getInt("DevicesChairZ"));
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        if (this.blockPos == null) {
            return;
        }
        compound.putInt("DevicesChairX", this.blockPos.getX());
        compound.putInt("DevicesChairY", this.blockPos.getY());
        compound.putInt("DevicesChairZ", this.blockPos.getZ());
    }
}

