/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.event;

import dev.ultreon.devices.api.WorldSavedData;
import dev.ultreon.devices.api.utils.BankUtil;
import dev.ultreon.devices.programs.email.EmailManager;
import dev.ultreon.mods.xinexlib.event.server.ServerLevelSaveEvent;
import dev.ultreon.mods.xinexlib.event.server.ServerStartingEvent;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class WorldDataHandler {
    private static final LevelResource DEVICES_MOD_DATA = new LevelResource("data/devices-mod");

    public static void init() {
    }

    private static void load(ServerStartingEvent event) {
        MinecraftServer minecraftServer = event.getServer();
        Path modData = Objects.requireNonNull(minecraftServer, "World loaded without server").getWorldPath(DEVICES_MOD_DATA);
        if (Files.notExists(modData, new LinkOption[0])) {
            try {
                Files.createDirectories(modData, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        WorldDataHandler.loadData(modData, "emails.dat", EmailManager.INSTANCE);
        WorldDataHandler.loadData(modData, "bank.dat", BankUtil.INSTANCE);
    }

    private static void save(ServerLevelSaveEvent event) {
        ServerLevel serverLevel = event.getServerLevel();
        if (!serverLevel.dimension().equals(ServerLevel.OVERWORLD)) {
            return;
        }
        MinecraftServer server = serverLevel.getServer();
        Path modData = server.getWorldPath(DEVICES_MOD_DATA);
        if (Files.notExists(modData, new LinkOption[0])) {
            try {
                Files.createDirectories(modData, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        WorldDataHandler.saveData(modData, "emails.dat", EmailManager.INSTANCE);
        WorldDataHandler.saveData(modData, "bank.dat", BankUtil.INSTANCE);
    }

    private static void loadData(Path modData, String fileName, WorldSavedData data) {
        Path dataFile = modData.resolve(fileName);
        if (!Files.exists(dataFile, new LinkOption[0])) {
            return;
        }
        try {
            CompoundTag nbt = NbtIo.readCompressed((Path)dataFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
            data.load(nbt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveData(Path modData, String fileName, WorldSavedData data) {
        try {
            Path dataFile = modData.resolve(fileName);
            if (Files.notExists(dataFile, new LinkOption[0])) {
                Files.createFile(dataFile, new FileAttribute[0]);
            }
            CompoundTag nbt = new CompoundTag();
            data.save(nbt);
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)dataFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EventSystem.MAIN.on(ServerStartingEvent.class, WorldDataHandler::load);
        EventSystem.MAIN.on(ServerLevelSaveEvent.class, WorldDataHandler::save);
    }
}

