/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.item;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.Router;
import dev.ultreon.devices.init.CableData;
import dev.ultreon.devices.init.DeviceDataComponents;
import dev.ultreon.devices.util.KeyboardHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EthernetCableItem
extends Item {
    public EthernetCableItem() {
        super(new Item.Properties().stacksTo(1));
    }

    private static double getDistance(BlockPos source, BlockPos target) {
        return Math.sqrt(source.distToCenterSqr((double)target.getX() + 0.5, (double)target.getY() + 0.5, (double)target.getZ() + 0.5));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        if (!level.isClientSide && player != null) {
            ItemStack heldItem = player.getItemInHand(hand);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RouterBlockEntity) {
                RouterBlockEntity routerBE = (RouterBlockEntity)blockEntity;
                if (!heldItem.has((DataComponentType)DeviceDataComponents.CABLE_DATA.get())) {
                    this.sendGameInfoMessage(player, "message.devices.invalid_cable");
                    return InteractionResult.SUCCESS;
                }
                Router router = routerBE.getRouter();
                CableData tag = (CableData)heldItem.get((DataComponentType)DeviceDataComponents.CABLE_DATA.get());
                assert (tag != null);
                BlockPos devicePos = tag.pos();
                BlockEntity tileEntity1 = level.getBlockEntity(devicePos);
                if (tileEntity1 instanceof NetworkDeviceBlockEntity) {
                    NetworkDeviceBlockEntity networkDeviceBlockEntity = (NetworkDeviceBlockEntity)tileEntity1;
                    if (!router.isDeviceRegistered(networkDeviceBlockEntity)) {
                        if (router.addDevice(networkDeviceBlockEntity)) {
                            networkDeviceBlockEntity.connect(router);
                            heldItem.shrink(1);
                            if (EthernetCableItem.getDistance(tileEntity1.getBlockPos(), routerBE.getBlockPos()) > (double)((Integer)DeviceConfig.SIGNAL_RANGE.get()).intValue()) {
                                this.sendGameInfoMessage(player, "message.devices.successful_registered");
                            } else {
                                this.sendGameInfoMessage(player, "message.devices.successful_connection");
                            }
                        } else {
                            this.sendGameInfoMessage(player, "message.devices.router_max_devices");
                        }
                    } else {
                        this.sendGameInfoMessage(player, "message.devices.device_already_connected");
                    }
                } else if (router.addDevice(tag.id(), tag.name())) {
                    heldItem.shrink(1);
                    this.sendGameInfoMessage(player, "message.devices.successful_registered");
                } else {
                    this.sendGameInfoMessage(player, "message.devices.router_max_devices");
                }
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof NetworkDeviceBlockEntity) {
                NetworkDeviceBlockEntity networkDeviceBlockEntity = (NetworkDeviceBlockEntity)blockEntity;
                CableData cableData = new CableData(networkDeviceBlockEntity.getBlockPos(), networkDeviceBlockEntity.getId(), networkDeviceBlockEntity.getCustomName());
                heldItem.set((DataComponentType)DeviceDataComponents.CABLE_DATA.get(), (Object)cableData);
                this.sendGameInfoMessage(player, "message.devices.select_router");
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void sendGameInfoMessage(Player player, String message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.sendSystemMessage((Component)Component.translatable((String)message));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (!level.isClientSide) {
            ItemStack heldItem = player.getItemInHand(usedHand);
            if (player.isCrouching()) {
                heldItem.remove(DataComponents.CUSTOM_NAME);
                heldItem.remove((DataComponentType)DeviceDataComponents.CABLE_DATA.get());
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
            }
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (stack.has((DataComponentType)DeviceDataComponents.CABLE_DATA.get())) {
            CableData tag = (CableData)stack.get((DataComponentType)DeviceDataComponents.CABLE_DATA.get());
            if (tag != null) {
                tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Connected to: " + String.valueOf(ChatFormatting.RESET) + tag.name())));
                tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Located at: " + String.valueOf(ChatFormatting.RESET) + tag.pos().getX() + ", " + tag.pos().getY() + ", " + tag.pos().getZ())));
                if (tooltipFlag.isAdvanced()) {
                    tooltipComponents.add((Component)Component.empty());
                    tooltipComponents.add((Component)Component.literal((String)(ChatFormatting.RED.toString() + String.valueOf(ChatFormatting.BOLD) + "ID: " + String.valueOf(ChatFormatting.RESET) + String.valueOf(tag.id()))));
                    tooltipComponents.add((Component)Component.literal((String)(ChatFormatting.RED.toString() + String.valueOf(ChatFormatting.BOLD) + "Device: " + String.valueOf(ChatFormatting.RESET) + tag.name())));
                    BlockPos devicePos = tag.pos();
                    String text = ChatFormatting.RED.toString() + String.valueOf(ChatFormatting.BOLD) + "X: " + String.valueOf(ChatFormatting.RESET) + devicePos.getX() + " " + String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + "Y: " + String.valueOf(ChatFormatting.RESET) + devicePos.getY() + " " + String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + "Z: " + String.valueOf(ChatFormatting.RESET) + devicePos.getZ();
                    tooltipComponents.add((Component)Component.literal((String)text));
                }
            }
        } else {
            if (!KeyboardHelper.isShiftDown()) {
                tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use this cable to connect")));
                tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "a device to a router.")));
                tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Hold SHIFT for How-To")));
                return;
            }
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Start by right clicking a")));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "device with this cable")));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "then right click the ")));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "router you want to")));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "connect this device to.")));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has((DataComponentType)DeviceDataComponents.CABLE_DATA.get());
    }

    @NotNull
    public Component getName(ItemStack stack) {
        if (stack.has((DataComponentType)DeviceDataComponents.CABLE_DATA.get())) {
            return super.getDescription().copy().withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
        }
        return super.getName(stack);
    }
}

