/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.item;

import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.DeviceTypeSupplier;
import dev.ultreon.devices.item.SubItems;
import dev.ultreon.devices.util.Colored;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class FlashDriveItem
extends Item
implements Colored,
SubItems,
DeviceTypeSupplier {
    private final DyeColor color;

    public FlashDriveItem(DyeColor color) {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1));
        this.color = color;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        TextColor textColor = TextColor.fromRgb((int)(this.color == DyeColor.BLACK ? 0xFFFFFF : this.color.getTextColor()));
        MutableComponent colorComponent = Component.literal((String)WordUtils.capitalize((String)this.color.getName().replace("_", " "))).withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(textColor));
        tooltipComponents.add((Component)Component.literal((String)"Color: ").withStyle(ChatFormatting.GRAY).append((Component)colorComponent));
    }

    @Override
    public NonNullList<ResourceLocation> getModels() {
        NonNullList modelLocations = NonNullList.create();
        for (DyeColor color : DyeColor.values()) {
            modelLocations.add((Object)ResourceLocation.fromNamespaceAndPath((String)"devices", (String)(BuiltInRegistries.ITEM.getKey((Object)this).getPath().substring(5) + "/" + color.getName())));
        }
        return modelLocations;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.FLASH_DRIVE;
    }
}

