/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.item;

import dev.ultreon.devices.init.DeviceDataComponents;
import dev.ultreon.devices.init.HardwareComponents;
import dev.ultreon.devices.item.ComponentItem;
import dev.ultreon.devices.util.KeyboardHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class MotherboardItem
extends ComponentItem {
    public MotherboardItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<net.minecraft.network.chat.Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        HardwareComponents tag = (HardwareComponents)stack.get((DataComponentType)DeviceDataComponents.HARDWARE_COMPONENTS.get());
        if (tag == null) {
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"Invalid Motherboard").withStyle(ChatFormatting.RED));
            return;
        }
        if (!KeyboardHelper.isShiftDown()) {
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "CPU: " + this.getComponentStatus(tag.cpu()))));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "RAM: " + this.getComponentStatus(tag.ram()))));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "GPU: " + this.getComponentStatus(tag.gpu()))));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "WIFI: " + this.getComponentStatus(tag.wifi()))));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Hold shift for help")));
        } else {
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"To add the required components"));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"place the motherboard and the"));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"corresponding component into a"));
            tooltipComponents.add((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"crafting table to combine them."));
        }
    }

    private String getComponentStatus(ItemStack cpu) {
        if (cpu != null) {
            return String.valueOf(ChatFormatting.GREEN) + "Added";
        }
        return String.valueOf(ChatFormatting.RED) + "Missing";
    }

    private String getComponentStatus(CompoundTag tag, String component) {
        CompoundTag components;
        if (tag != null && tag.contains("components", 10) && (components = tag.getCompound("components")).contains(component, 1)) {
            return String.valueOf(ChatFormatting.GREEN) + "Added";
        }
        return String.valueOf(ChatFormatting.RED) + "Missing";
    }

    public static class Component
    extends ComponentItem {
        public Component(Item.Properties properties) {
            super(properties);
        }
    }
}

