/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.neoforge;

import com.mojang.logging.LogUtils;
import dev.ultreon.devices.ClientModEvents;
import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.init.RegistrationHandler;
import dev.ultreon.mods.xinexlib.Env;
import dev.ultreon.mods.xinexlib.platform.NeoForgePlatform;
import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.slf4j.Logger;

@Mod(value="devices")
public final class UltreonDevicesNeo {
    public static final Logger LOGGER = LogUtils.getLogger();
    private final UltreonDevices instance = new UltreonDevices(this){

        @Override
        protected List<Application> loadApps() {
            return (List)ObfuscationReflectionHelper.getPrivateValue(ComputerScreen.class, null, (String)"APPLICATIONS");
        }

        @Override
        public String getVersion() {
            return MavenVersionTranslator.artifactVersionToString((ArtifactVersion)((ModContainer)ModList.get().getModContainerById("devices").orElseThrow()).getModInfo().getVersion());
        }

        @Override
        public int getBurnTime(ItemStack stack, RecipeType<?> type) {
            return stack.getBurnTime(type);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected void setRegisteredRenders(Map<String, IPrint.Renderer> map) {
            ObfuscationReflectionHelper.setPrivateValue(PrintingManager.class, null, map, (String)"registeredRenders");
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected Map<String, IPrint.Renderer> getRegisteredRenders() {
            return (Map)ObfuscationReflectionHelper.getPrivateValue(PrintingManager.class, null, (String)"registeredRenders");
        }
    };
    public IEventBus modEventBus;

    public UltreonDevicesNeo(IEventBus modEventBus, ModContainer container) {
        NeoForgePlatform.getPlatform().registerMod(container.getModId(), modEventBus);
        this.modEventBus = modEventBus;
        UltreonDevices.preInit();
        LOGGER.info("Initializing registration handler and mod config.");
        RegistrationHandler.register();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DeviceConfig.CONFIG);
        LOGGER.info("Registering common setup handler, and load complete handler.");
        if (XinexPlatform.getEnv() == Env.CLIENT) {
            UltreonDevices.doClientInit();
        }
        modEventBus.addListener(this::onLoadComplete);
        LOGGER.info("Registering server setup handler.");
        modEventBus.addListener(this::onServerSetup);
        this.instance.registerApplications();
        if (!DatagenModLoader.isRunningDataGen()) {
            LOGGER.info("Registering the reload listener.");
            ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)new ClientModEvents.ReloaderListener());
        }
        this.instance.init();
    }

    private void onServerSetup(FMLDedicatedServerSetupEvent t) {
        t.enqueueWork(this.instance::serverSetup);
    }

    private void onLoadComplete(FMLLoadCompleteEvent t) {
        t.enqueueWork(this.instance::loadComplete);
    }
}

