/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.network.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.network.PacketHandler;
import dev.ultreon.devices.network.task.ResponsePacket;
import dev.ultreon.mods.xinexlib.network.Networker;
import dev.ultreon.mods.xinexlib.network.packet.PacketToServer;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RequestPacket
implements PacketToServer<RequestPacket> {
    private final int id;
    private final Task request;
    private CompoundTag tag;

    public RequestPacket(RegistryFriendlyByteBuf buf) {
        this.id = buf.readInt();
        String name = buf.readUtf();
        this.request = TaskManager.getTask(name).get();
        this.tag = buf.readNbt();
    }

    public RequestPacket(int id, Task request) {
        this.id = id;
        this.request = request;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeUtf(this.request.getName());
        CompoundTag tag = new CompoundTag();
        this.request.prepareRequest((HolderLookup.Provider)buf.registryAccess(), tag);
        buf.writeNbt((Tag)tag);
    }

    public void handle(Networker networker, ServerPlayer player) {
        this.request.processRequest((HolderLookup.Provider)player.level().registryAccess(), this.tag, Objects.requireNonNull(player).level(), (Player)player);
        PacketHandler.sendToClient(new ResponsePacket(this.id, this.request), player);
    }

    public int getId() {
        return this.id;
    }
}

